/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.handler;

import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.http.server.handler.HttpRequestHandler;
import com.litongjava.tio.http.server.intf.ThrowableHandler;
import com.litongjava.tio.http.server.router.HttpRequestRouter;
import com.litongjava.tio.http.server.util.Resps;

public class DefaultHttpRequestDispatcher
implements ITioHttpRequestHandler {
    private HttpRequestRouter httpRoutes;
    private HttpConfig httpConfig;
    private ThrowableHandler throwableHandler;

    public DefaultHttpRequestDispatcher(HttpConfig httpConfig, HttpRequestRouter httpRoutes) {
        this.httpRoutes = httpRoutes;
        this.httpConfig = httpConfig;
    }

    public HttpResponse handler(HttpRequest httpRequest) throws Exception {
        RequestLine requestLine = httpRequest.getRequestLine();
        String path = requestLine.getPath();
        HttpRequestHandler handler = this.httpRoutes.find(path);
        if (handler == null) {
            return this.resp404(httpRequest, requestLine);
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = handler.handle(httpRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.resp500(httpRequest, requestLine, e);
        }
        return httpResponse;
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) throws Exception {
        HttpRequestHandler handler;
        String page404;
        if (this.httpRoutes != null && (page404 = this.httpConfig.getPage404()) != null && (handler = this.httpRoutes.find(page404)) != null) {
            return handler.handle(request);
        }
        return Resps.resp404(request, requestLine, this.httpConfig);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) throws Exception {
        HttpRequestHandler handler;
        String page500;
        if (this.throwableHandler != null) {
            return this.throwableHandler.handler(request, requestLine, throwable);
        }
        if (this.httpRoutes != null && (page500 = this.httpConfig.getPage500()) != null && (handler = this.httpRoutes.find(page500)) != null) {
            return handler.handle(request);
        }
        return Resps.resp500(request, requestLine, this.httpConfig, throwable);
    }

    public HttpConfig getHttpConfig(HttpRequest request) {
        return request.getHttpConfig();
    }

    public void clearStaticResCache() {
    }
}

