/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server;

import com.litongjava.aio.AioId;
import com.litongjava.model.cache.ICache;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpId;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.http.common.session.id.ISessionIdGenerator;
import com.litongjava.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import com.litongjava.tio.http.server.HttpServerAioHandler;
import com.litongjava.tio.http.server.HttpServerAioListener;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.server.TioServer;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.server.intf.ServerAioListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.mapcache.ConcurrentMapCacheFactory;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.hutool.FileUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerStarter {
    private static Logger log = LoggerFactory.getLogger(HttpServerStarter.class);
    private HttpConfig httpConfig = null;
    private HttpServerAioHandler httpServerAioHandler = null;
    private HttpServerAioListener httpServerAioListener = null;
    private ServerTioConfig serverTioConfig = null;
    private TioServer tioServer = null;
    private ITioHttpRequestHandler httpRequestHandler = null;
    private List<String> preAccessFileType = new ArrayList<String>();

    public HttpServerStarter(HttpConfig httpConfig, ITioHttpRequestHandler requestHandler) {
        this.preAccessFileType.add("html");
        this.preAccessFileType.add("ftl");
        this.init(httpConfig, requestHandler);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public ITioHttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public HttpServerAioHandler getHttpServerAioHandler() {
        return this.httpServerAioHandler;
    }

    public HttpServerAioListener getHttpServerAioListener() {
        return this.httpServerAioListener;
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    private void init(HttpConfig httpConfig, ITioHttpRequestHandler requestHandler) {
        String system_timer_period = System.getProperty("tio.system.timer.period");
        if (StrUtil.isBlank((String)system_timer_period)) {
            System.setProperty("tio.system.timer.period", "50");
        }
        this.httpConfig = httpConfig;
        this.httpRequestHandler = requestHandler;
        httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.httpServerAioHandler = new HttpServerAioHandler(httpConfig, requestHandler);
        this.httpServerAioListener = new HttpServerAioListener();
        String name = httpConfig.getName();
        if (StrUtil.isBlank((String)name)) {
            name = "Tio Http Server";
        }
        this.serverTioConfig = new ServerTioConfig(name);
        this.serverTioConfig.setServerAioListener((ServerAioListener)this.httpServerAioListener);
        this.serverTioConfig.setServerAioHandler((ServerAioHandler)this.httpServerAioHandler);
        this.serverTioConfig.setHeartbeatTimeout(20000L);
        this.serverTioConfig.setShortConnection(true);
        this.serverTioConfig.setReadBufferSize(132476);
        this.serverTioConfig.setCacheFactory((CacheFactory)ConcurrentMapCacheFactory.INSTANCE);
        this.serverTioConfig.setAttribute("TIO_HTTP_REQ_HANDLER", (Object)this.httpRequestHandler);
        this.serverTioConfig.setDefaultIpRemovalListenerWrapper();
        this.tioServer = new TioServer(this.serverTioConfig);
        HttpId imTioUuid = new HttpId();
        this.serverTioConfig.setTioUuid((AioId)imTioUuid);
    }

    public void setHttpRequestHandler(ITioHttpRequestHandler requestHandler) {
        this.httpRequestHandler = requestHandler;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean preAccess) throws IOException {
        this.serverTioConfig.init();
        if (this.httpConfig.isUseSession()) {
            CacheFactory cacheFactory;
            if (this.httpConfig.getSessionStore() == null && (cacheFactory = this.serverTioConfig.getCacheFactory()) != null) {
                AbsCache absCache = cacheFactory.register(this.httpConfig.getSessionCacheName(), null, Long.valueOf(this.httpConfig.getSessionTimeout()));
                this.httpConfig.setSessionStore((ICache)absCache);
            }
            if (this.httpConfig.getSessionIdGenerator() == null) {
                this.httpConfig.setSessionIdGenerator((ISessionIdGenerator)UUIDSessionIdGenerator.INSTANCE);
            }
        }
        this.tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort().intValue());
        if (preAccess) {
            this.preAccess();
        }
    }

    public void preAccess() {
        if (this.httpConfig.isPageInClasspath()) {
            log.info("\u6682\u65f6\u53ea\u652f\u6301\u76ee\u5f55\u5f62\u5f0f\u7684\u9884\u8bbf\u95ee");
            return;
        }
        final String pageRoot = this.httpConfig.getPageRoot();
        if (pageRoot == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                TreeMap pathCostMap = new TreeMap();
                long start = System.currentTimeMillis();
                HttpServerStarter.this.preAccess(pageRoot, pathCostMap);
                long end = System.currentTimeMillis();
                long iv = end - start;
                TreeMap<Long, TreeSet<String>> costPathsMap = new TreeMap<Long, TreeSet<String>>(new Comparator<Long>(){

                    @Override
                    public int compare(Long o1, Long o2) {
                        return Long.compare(o2, o1);
                    }
                });
                Set entrySet = pathCostMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    try {
                        boolean added;
                        Long cost = (Long)entry.getValue();
                        String path = (String)entry.getKey();
                        TreeSet<String> pathSet = (TreeSet<String>)costPathsMap.get(cost);
                        if (pathSet == null) {
                            pathSet = new TreeSet<String>();
                            costPathsMap.put(cost, pathSet);
                        }
                        if (added = pathSet.add(path)) continue;
                        log.error("\u53ef\u80fd\u91cd\u590d\u8bbf\u95ee\u4e86:{}", (Object)path);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                Json json = Json.getJson();
                log.info("\u9884\u8bbf\u95ee\u4e86{}\u4e2apath\uff0c\u8017\u65f6:{}ms\uff0c\u8bbf\u95ee\u8be6\u60c5:\r\n{}\r\n\u8017\u65f6\u6392\u5e8f:\r\n{}", new Object[]{pathCostMap.size(), iv, json.toJson(pathCostMap), json.toJson(costPathsMap)});
            }
        }).start();
    }

    private void preAccess(String rootpath, Map<String, Long> pathCostMap) {
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("host", "127.0.0.1");
            String protocol = null;
            protocol = this.serverTioConfig.isSsl() ? "https" : "http";
            String completePathPrefix = protocol + "://127.0.0.1:" + this.httpConfig.getBindPort();
            File rootDir = new File(rootpath);
            File[] files = rootDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String filename = file.getName();
                    String extension = FileUtil.extName((String)filename);
                    if (file.isDirectory()) {
                        return !"svn-base".equalsIgnoreCase(extension);
                    }
                    String ext = FileUtil.extName((File)file);
                    return HttpServerStarter.this.preAccessFileType.contains(ext);
                }
            });
            File pageRootFile = new File(this.httpConfig.getPageRoot());
            String pageRootAbs = pageRootFile.getCanonicalPath();
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        this.preAccess(file.getCanonicalPath(), pathCostMap);
                        continue;
                    }
                    String absPath = file.getCanonicalPath();
                    log.info("pageRoot:{}, \u9884\u8bbf\u95ee\u8def\u5f84getAbsolutePath:{}", (Object)this.httpConfig.getPageRoot(), (Object)absPath);
                    long start = System.currentTimeMillis();
                    String path = absPath.substring(pageRootAbs.length());
                    if (!path.startsWith("/") && !path.startsWith("\\")) {
                        path = "/" + path;
                    }
                    log.info("\u9884\u8bbf\u95ee\u8def\u5f84:{}", (Object)path);
                    String url = completePathPrefix + path;
                    Response response = HttpUtils.get((String)url, headerMap);
                    long end = System.currentTimeMillis();
                    long iv = end - start;
                    pathCostMap.put(path, iv);
                    log.info("\u9884\u8bbf\u95ee\u5b8c\u6210\uff0c\u8017\u65f6{}ms, [{}], {}", new Object[]{iv, path, response});
                    response.close();
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("\u9884\u8bbf\u95ee\u62a5\u9519", (Throwable)e);
        }
    }

    public void stop() throws IOException {
        this.tioServer.stop();
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }
}

