/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.server;

import com.litongjava.enhance.channel.EnhanceAsynchronousChannelProvider;
import com.litongjava.enhance.channel.EnhanceAsynchronousServerSocketChannel;
import com.litongjava.tio.core.Node;
import com.litongjava.tio.server.AcceptCompletionHandler;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.utils.Threads;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioServer {
    private static final Logger log = LoggerFactory.getLogger(TioServer.class);
    private ServerTioConfig serverTioConfig;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private Node serverNode;
    private boolean isWaitingStop = false;
    private static ExecutorService groupExecutor;
    private static AsynchronousChannelGroup channelGroup;

    public TioServer(ServerTioConfig serverTioConfig) {
        this.serverTioConfig = serverTioConfig;
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setServerTioConfig(ServerTioConfig serverTioConfig) {
        this.serverTioConfig = serverTioConfig;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        this.serverTioConfig.init();
        this.serverTioConfig.getCacheFactory().register("reqeust_processing", null, null, null);
        this.serverNode = new Node(serverIp, serverPort);
        if (EnvUtils.getBoolean((String)"tio.core.hotswap.reload", (boolean)false)) {
            groupExecutor = Threads.getGroupExecutor();
            channelGroup = AsynchronousChannelGroup.withThreadPool(groupExecutor);
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(channelGroup);
        } else {
            EnhanceAsynchronousChannelProvider provider = new EnhanceAsynchronousChannelProvider(false);
            int workerThreads = this.serverTioConfig.getWorkerThreads();
            log.info("{} workerThreads:{}", (Object)this.serverTioConfig.getName(), (Object)workerThreads);
            final AtomicInteger threadNumber = new AtomicInteger(1);
            AsynchronousChannelGroup group = provider.openAsynchronousChannelGroup(workerThreads, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "t-io-" + threadNumber.getAndIncrement());
                }
            });
            this.serverSocketChannel = (EnhanceAsynchronousServerSocketChannel)provider.openAsynchronousServerSocketChannel(group);
        }
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, this.serverTioConfig.getBacklog());
        AcceptCompletionHandler acceptCompletionHandler = new AcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.serverTioConfig.startTime = System.currentTimeMillis();
        Threads.getTioExecutor();
    }

    public boolean stop() {
        this.isWaitingStop = true;
        if (channelGroup != null && !channelGroup.isShutdown()) {
            try {
                channelGroup.shutdownNow();
                if (!channelGroup.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("channelGroup did not terminate within the timeout");
                }
            }
            catch (Exception e) {
                log.error("Faild to execute channelGroup.shutdownNow()", (Throwable)e);
            }
        }
        if (groupExecutor != null && !groupExecutor.isShutdown()) {
            try {
                groupExecutor.shutdownNow();
                if (!groupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("groupExecutor did not terminate within the timeout");
                }
            }
            catch (Exception e) {
                log.error("Failed to close groupExecutor", (Throwable)e);
            }
        }
        if (this.serverSocketChannel != null && this.serverSocketChannel.isOpen()) {
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception e) {
                log.error("Failed to close serverSocketChannel", (Throwable)e);
            }
        }
        this.serverTioConfig.setStopped(true);
        boolean ret = Threads.close();
        log.info(this.serverNode + " stopped");
        return ret;
    }
}

