/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.task;

import com.litongjava.aio.Packet;
import com.litongjava.enhance.channel.EnhanceAsynchronousServerChannel;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.WriteCompletionHandler;
import com.litongjava.tio.core.intf.AioHandler;
import com.litongjava.tio.core.ssl.SslUtils;
import com.litongjava.tio.core.ssl.SslVo;
import com.litongjava.tio.core.utils.TioUtils;
import com.litongjava.tio.core.vo.WriteCompletionVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.LockSupport;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPacketTask {
    private static final Logger log = LoggerFactory.getLogger(SendPacketTask.class);
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);
    public boolean canSend = true;
    private ChannelContext channelContext = null;
    private TioConfig tioConfig = null;
    private AioHandler aioHandler = null;
    private boolean isSsl = false;

    public SendPacketTask(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.aioHandler = this.tioConfig.getAioHandler();
        this.isSsl = SslUtils.isSsl(this.tioConfig);
    }

    private ByteBuffer getByteBuffer(Packet packet) {
        ByteBuffer byteBuffer = packet.getPreEncodedByteBuffer();
        try {
            if (byteBuffer == null) {
                byteBuffer = this.aioHandler.encode(packet, this.tioConfig, this.channelContext);
            }
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.flip();
            }
            return byteBuffer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean sendPacket(Packet packet) {
        if (DIAGNOSTIC_LOG_ENABLED) {
            log.info("send:{},{}", (Object)this.channelContext.getClientNode(), (Object)packet);
        }
        this.channelContext.sendQueue.offer(packet);
        if (this.channelContext.isSending.compareAndSet(false, true)) {
            Packet nextPacket = this.channelContext.sendQueue.poll();
            if (nextPacket != null) {
                ByteBuffer byteBuffer = this.getByteBuffer(nextPacket);
                if (this.isSsl && !packet.isSslEncrypted()) {
                    SslVo sslVo = new SslVo(byteBuffer, nextPacket);
                    try {
                        this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                        byteBuffer = sslVo.getByteBuffer();
                    }
                    catch (SSLException e) {
                        log.error(this.channelContext.toString() + ", An exception occurred while performing SSL encryption", (Throwable)e);
                        Tio.close(this.channelContext, "An exception occurred during SSL encryption.", ChannelContext.CloseCode.SSL_ENCRYPTION_ERROR);
                        return false;
                    }
                }
                AsynchronousSocketChannel asc = this.channelContext.asynchronousSocketChannel;
                File fileBody = packet.getFileBody();
                if (fileBody != null && asc instanceof EnhanceAsynchronousServerChannel) {
                    boolean keepConnection = nextPacket.isKeepConnection();
                    nextPacket.setKeepConnection(true);
                    this.sendByteBuffer(byteBuffer, nextPacket);
                    this.transfer(fileBody, nextPacket, asc);
                    if (!keepConnection) {
                        Tio.close(this.channelContext, "Send file finish");
                    }
                } else {
                    this.sendByteBuffer(byteBuffer, nextPacket);
                }
            } else {
                this.channelContext.isSending.set(false);
            }
        }
        return true;
    }

    private void transfer(File fileBody, Packet nextPacket, AsynchronousSocketChannel asc) {
        SocketChannel sc = ((EnhanceAsynchronousServerChannel)asc).getSocketChannel();
        if (!this.isSsl) {
            try (FileChannel fc = FileChannel.open(fileBody.toPath(), StandardOpenOption.READ);){
                long pos = 0L;
                long size = fc.size();
                while (pos < size) {
                    long sent = fc.transferTo(pos, size - pos, sc);
                    if (sent > 0L) {
                        pos += sent;
                        continue;
                    }
                    LockSupport.parkNanos(1000L);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileChannel fc = FileChannel.open(fileBody.toPath(), StandardOpenOption.READ);){
                int readBytes;
                ByteBuffer buf = ByteBuffer.allocate(65536);
                while ((readBytes = fc.read(buf)) != -1) {
                    if (readBytes == 0) continue;
                    buf.flip();
                    SslVo sslVo = new SslVo(buf, nextPacket);
                    try {
                        this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                    }
                    catch (SSLException e) {
                        log.error("Failed to encrypt data using ssl", (Throwable)e);
                        Tio.close(this.channelContext, "Failed to encrypt data using ssl", ChannelContext.CloseCode.SSL_ENCRYPTION_ERROR);
                    }
                    ByteBuffer encrypted = sslVo.getByteBuffer();
                    sc.write(encrypted);
                    buf.clear();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void sendByteBuffer(ByteBuffer byteBuffer, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", (Object)this.channelContext);
            return;
        }
        if (!TioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        WriteCompletionVo writeCompletionVo = new WriteCompletionVo(byteBuffer, packets);
        WriteCompletionHandler writeCompletionHandler = new WriteCompletionHandler(this.channelContext);
        this.channelContext.asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, writeCompletionHandler);
    }

    public void processSendQueue() {
        if (this.channelContext.isSending.compareAndSet(false, true)) {
            Packet nextPacket = this.channelContext.sendQueue.poll();
            if (nextPacket != null) {
                ByteBuffer byteBuffer = this.getByteBuffer(nextPacket);
                if (this.isSsl && !nextPacket.isSslEncrypted()) {
                    SslVo sslVo = new SslVo(byteBuffer, nextPacket);
                    try {
                        this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                        byteBuffer = sslVo.getByteBuffer();
                    }
                    catch (SSLException e) {
                        log.error(this.channelContext.toString() + ", An exception occurred while performing SSL encryption", (Throwable)e);
                        Tio.close(this.channelContext, "An exception occurred during SSL encryption.", ChannelContext.CloseCode.SSL_ENCRYPTION_ERROR);
                    }
                }
                this.sendByteBuffer(byteBuffer, nextPacket);
            } else {
                this.channelContext.isSending.set(false);
            }
        }
    }
}

