/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.task;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.exception.AioDecodeException;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.core.stat.ChannelStat;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.core.task.HandlePacketTask;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import com.litongjava.tio.exception.TioHandlePacketException;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.CollUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeTask {
    private static final Logger log = LoggerFactory.getLogger(DecodeTask.class);
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);
    private ByteBuffer lastByteBuffer = null;
    private int lastPercentage = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void decode(ChannelContext channelContext, ByteBuffer byteBuffer) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (DIAGNOSTIC_LOG_ENABLED) {
            log.info("decode:{}", (Object)channelContext.getClientNode());
        }
        if (this.lastByteBuffer != null) {
            byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
            this.lastByteBuffer = null;
        }
        while (true) {
            int initPosition = byteBuffer.position();
            int limit = byteBuffer.limit();
            int readableLength = limit - initPosition;
            Packet packet = null;
            try {
                block34: {
                    if (channelContext.packetNeededLength != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("{}, Length required for decoding:{}", (Object)channelContext, (Object)channelContext.packetNeededLength);
                        }
                        if (readableLength >= channelContext.packetNeededLength) {
                            packet = tioConfig.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, channelContext);
                            break block34;
                        } else {
                            int percentage = (int)((double)readableLength / (double)channelContext.packetNeededLength.intValue() * 100.0);
                            if (percentage != this.lastPercentage) {
                                this.lastPercentage = percentage;
                                if (tioConfig.disgnostic) {
                                    log.info("Receiving large packet: received {}% of {} bytes.", (Object)percentage, (Object)channelContext.packetNeededLength);
                                }
                            }
                            this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, limit);
                            return;
                        }
                    }
                    try {
                        packet = tioConfig.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, channelContext);
                    }
                    catch (Exception e) {
                        log.error("Failed to decode:{}", (Object)channelContext, (Object)e);
                    }
                }
                if (packet == null) {
                    int per;
                    this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, limit);
                    ChannelStat channelStat = channelContext.stat;
                    ++channelStat.decodeFailCount;
                    if (channelContext.getTioConfig().checkAttacks && channelStat.decodeFailCount > 10 && (per = readableLength / channelStat.decodeFailCount) < Math.min(channelContext.getReadBufferSize() / 2, 256)) {
                        String str = "Failed to decode continuously " + channelStat.decodeFailCount + " times unsuccessfully, and the average data received each time is " + per + " bytes, which suggests the possibility of a slow attack";
                        log.warn(str);
                        throw new AioDecodeException(str);
                    }
                    if (!log.isInfoEnabled()) return;
                    if (channelContext.getTioConfig().ignoreDecodeFail) return;
                    if (channelStat.decodeFailCount <= 3) return;
                    if (channelContext.packetNeededLength != null) return;
                    log.info("{} Failed to decode for {} consecutive times, the length of data involved in decoding is {} bytes.", new Object[]{channelContext, channelStat.decodeFailCount, readableLength});
                    return;
                }
                channelContext.setPacketNeededLength(null);
                channelContext.stat.latestTimeOfReceivedPacket = SystemTimer.currTime;
                channelContext.stat.decodeFailCount = 0;
                int packetSize = byteBuffer.position() - initPosition;
                packet.setByteCount(packetSize);
                if (tioConfig.statOn) {
                    tioConfig.groupStat.receivedPackets.incrementAndGet();
                    channelContext.stat.receivedPackets.incrementAndGet();
                }
                if (CollUtil.isNotEmpty(tioConfig.ipStats.durationList)) {
                    try {
                        for (Long v : tioConfig.ipStats.durationList) {
                            IpStat ipStat = tioConfig.ipStats.get(v, channelContext);
                            ipStat.getReceivedPackets().incrementAndGet();
                            tioConfig.getIpStatListener().onAfterDecoded(channelContext, packet, packetSize, ipStat);
                        }
                    }
                    catch (Exception e1) {
                        log.error(packet.logstr(), (Throwable)e1);
                    }
                }
                if (tioConfig.getAioListener() != null) {
                    try {
                        tioConfig.getAioListener().onAfterDecoded(channelContext, packet, packetSize);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}, Unpacking to get a packet:{}", (Object)channelContext, (Object)packet.logstr());
                }
                try {
                    new HandlePacketTask().handle(channelContext, packet);
                }
                catch (TioHandlePacketException e) {
                    byteBuffer.mark();
                    String request = StandardCharsets.UTF_8.decode(byteBuffer).toString();
                    byteBuffer.reset();
                    log.error("Failed to handle request:{},packet:{},byteBuffer:{}", new Object[]{request, packet, byteBuffer, e});
                }
                if (!byteBuffer.hasRemaining()) {
                    this.lastByteBuffer = null;
                    if (!log.isDebugEnabled()) return;
                    log.debug("{},After grouping the packets, the data just ran out", (Object)channelContext);
                    return;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("{},After grouping packets, there is still data left:{}", (Object)channelContext, (Object)byteBuffer.remaining());
            }
            catch (Throwable e) {
                if (channelContext.logWhenDecodeError) {
                    log.error("Encountered an exception while decoding", e);
                }
                channelContext.setPacketNeededLength(null);
                if (e instanceof AioDecodeException || e instanceof TioDecodeException) {
                    List<Long> list = tioConfig.ipStats.durationList;
                    if (list != null && list.size() > 0) {
                        try {
                            for (Long v : list) {
                                IpStat ipStat = tioConfig.ipStats.get(v, channelContext);
                                ipStat.getDecodeErrorCount().incrementAndGet();
                                tioConfig.getIpStatListener().onDecodeError(channelContext, ipStat);
                            }
                        }
                        catch (Exception e1) {
                            log.error(e1.toString(), (Throwable)e1);
                        }
                    }
                } else {
                    log.error(e.getMessage(), e);
                }
                Tio.close(channelContext, e, "Decode exception:" + e.getMessage(), ChannelContext.CloseCode.DECODE_ERROR);
                return;
            }
        }
    }
}

