/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.ssl;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.ssl.SslFacadeContext;
import com.litongjava.tio.core.ssl.SslVo;
import com.litongjava.tio.core.ssl.facade.ISSLListener;
import com.litongjava.tio.core.task.DecodeTask;
import com.litongjava.tio.core.task.SendPacketTask;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslListener
implements ISSLListener {
    private static Logger log = LoggerFactory.getLogger(SslListener.class);
    private ChannelContext channelContext = null;

    public SslListener(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void onWrappedData(SslVo sslVo) {
        log.info("{}, Received data after SSL encryption, ready to be sent out {}", (Object)this.channelContext, (Object)sslVo);
        Object obj = sslVo.getObj();
        if (obj == null) {
            Packet p = new Packet();
            p.setPreEncodedByteBuffer(sslVo.getByteBuffer());
            p.setSslEncrypted(true);
            new SendPacketTask(this.channelContext).sendPacket(p);
        }
    }

    @Override
    public void onPlainData(ByteBuffer plainBuffer) {
        SslFacadeContext sslFacadeContext = this.channelContext.sslFacadeContext;
        if (sslFacadeContext.isHandshakeCompleted()) {
            log.info("{}, After receiving the data decrypted by SSL, the SSL handshake is complete and ready to be decoded\uff0c{}, isSSLHandshakeCompleted {}", new Object[]{this.channelContext, plainBuffer, sslFacadeContext.isHandshakeCompleted()});
            new DecodeTask().decode(this.channelContext, plainBuffer);
        } else {
            log.info("{}, SSL decrypted data is received, but the SSL handshake is not complete\uff0c{}, isSSLHandshakeCompleted {}", new Object[]{this.channelContext, plainBuffer, sslFacadeContext.isHandshakeCompleted()});
        }
    }
}

