/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.LockUtils;
import com.litongjava.tio.utils.lock.MapWithLock;
import com.litongjava.tio.utils.lock.SetWithLock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tokens {
    private static Logger log = LoggerFactory.getLogger(Tokens.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> mapWithLock = new MapWithLock(new HashMap());
    private final Object synLockObj1 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String token, ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            return;
        }
        try {
            SetWithLock setWithLock = (SetWithLock)this.mapWithLock.get((Object)token);
            if (setWithLock == null) {
                LockUtils.runWriteOrWaitRead((String)("_tio_tokens_bind__" + token), (Object)this.synLockObj1, () -> {
                    if (this.mapWithLock.get((Object)token) == null) {
                        this.mapWithLock.put((Object)token, (Object)new SetWithLock(new HashSet()));
                    }
                });
                setWithLock = (SetWithLock)this.mapWithLock.get((Object)token);
            }
            setWithLock.add((Object)channelContext);
            channelContext.setToken(token);
        }
        catch (Throwable e) {
            log.error("", e);
        }
    }

    public SetWithLock<ChannelContext> find(TioConfig tioConfig, String token) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        String key = token;
        ReentrantReadWriteLock.ReadLock lock = this.mapWithLock.readLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            SetWithLock setWithLock = (SetWithLock)m.get(key);
            return setWithLock;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getMap() {
        return this.mapWithLock;
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String token = channelContext.getToken();
            if (StrUtil.isBlank((CharSequence)token)) {
                log.debug("{}, {}, unbind token", (Object)channelContext.tioConfig.getName(), (Object)channelContext.toString());
                return;
            }
            SetWithLock setWithLock = (SetWithLock)this.mapWithLock.get((Object)token);
            if (setWithLock == null) {
                log.warn("{}, {}, token:{}, can't find SetWithLock", new Object[]{channelContext.tioConfig.getName(), channelContext.toString(), token});
                return;
            }
            channelContext.setToken(null);
            setWithLock.remove((Object)channelContext);
            if (setWithLock.size() == 0) {
                this.mapWithLock.remove((Object)token);
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(TioConfig tioConfig, String token) {
        if (tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            return;
        }
        SetWithLock setWithLock = (SetWithLock)this.mapWithLock.get((Object)token);
        if (setWithLock == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)setWithLock.getObj();
            if (set.size() > 0) {
                for (ChannelContext channelContext : set) {
                    channelContext.setToken(null);
                }
                set.clear();
            }
            this.mapWithLock.remove((Object)token);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

