/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.hutool.CollUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpStats {
    private static Logger log = LoggerFactory.getLogger(IpStats.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String tioConfigId;
    private TioConfig tioConfig;
    public final Map<Long, AbsCache> cacheMap = new HashMap<Long, AbsCache>();
    public List<Long> durationList = null;

    public IpStats(TioConfig tioConfig, Long[] durations) {
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            this.addDurations(durations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDuration(Long duration) {
        IpStats ipStats = this;
        synchronized (ipStats) {
            if (this.durationList == null) {
                this.durationList = new ArrayList<Long>();
            }
            RemovalListenerWrapper<?> removalListenerWrapper = this.tioConfig.getIpRemovalListenerWrapper();
            AbsCache caffeineCache = this.tioConfig.getCacheFactory().register(this.getCacheName(duration), duration, null, removalListenerWrapper);
            this.cacheMap.put(duration, caffeineCache);
            this.durationList.add(duration);
        }
    }

    public void addDurations(Long[] durations) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration);
            }
        }
    }

    public void removeDuration(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        if (CollUtil.isNotEmpty(this.durationList)) {
            this.durationList.remove(duration);
        }
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_STAT_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        AbsCache cache = this.cacheMap.get(duration);
        if (cache == null) {
            return;
        }
        cache.clear();
    }

    public IpStat get(Long duration, ChannelContext channelContext) {
        return this.get(duration, channelContext, true);
    }

    public IpStat get(Long duration, ChannelContext channelContext, boolean forceCreate) {
        return this._get(duration, channelContext, forceCreate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat _get(Long duration, ChannelContext channelContext, boolean forceCreate, boolean useProxyClient) {
        if (channelContext == null) {
            return null;
        }
        AbsCache cache = this.cacheMap.get(duration);
        if (cache == null) {
            return null;
        }
        String ip = null;
        ip = useProxyClient && channelContext.getProxyClientNode() != null ? channelContext.getProxyClientNode().getIp() : channelContext.getClientNode().getIp();
        IpStat ipStat = (IpStat)cache.get(ip);
        if (ipStat == null && forceCreate) {
            IpStats ipStats = this;
            synchronized (ipStats) {
                ipStat = (IpStat)cache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip, duration);
                    cache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public Map<String, Serializable> map(Long duration) {
        AbsCache cache = this.cacheMap.get(duration);
        if (cache == null) {
            return null;
        }
        Map map = cache.asMap();
        return map;
    }

    public Long size(Long duration) {
        AbsCache cache = this.cacheMap.get(duration);
        if (cache == null) {
            return null;
        }
        return cache.size();
    }

    public Collection<Serializable> values(Long duration) {
        AbsCache cache = this.cacheMap.get(duration);
        if (cache == null) {
            return null;
        }
        Collection<Serializable> set = cache.asMap().values();
        return set;
    }
}

