/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.MapWithLock;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsIds {
    private static Logger log = LoggerFactory.getLogger(BsIds.class);
    private MapWithLock<String, ChannelContext> map = new MapWithLock(new HashMap());

    public void bind(ChannelContext channelContext, String bsId) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            this.unbind(channelContext);
            if (StrUtil.isBlank((CharSequence)bsId)) {
                return;
            }
            channelContext.setBsId(bsId);
            this.map.put((Object)bsId, (Object)channelContext);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public ChannelContext find(TioConfig tioConfig, String bsId) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)bsId)) {
            return null;
        }
        return (ChannelContext)((Object)this.map.get((Object)bsId));
    }

    public MapWithLock<String, ChannelContext> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (tioConfig.isShortConnection) {
            return;
        }
        String bsId = channelContext.getBsId();
        if (StrUtil.isBlank((CharSequence)bsId)) {
            return;
        }
        try {
            this.map.remove((Object)bsId);
            channelContext.setBsId(null);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }
}

