/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core;

import com.litongjava.aio.AioId;
import com.litongjava.aio.Packet;
import com.litongjava.tio.client.ClientTioConfig;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.DefaultTAioId;
import com.litongjava.tio.core.PacketConverter;
import com.litongjava.tio.core.cache.IpStatMapCacheRemovalListener;
import com.litongjava.tio.core.intf.AioHandler;
import com.litongjava.tio.core.intf.AioListener;
import com.litongjava.tio.core.intf.GroupListener;
import com.litongjava.tio.core.maintain.BsIds;
import com.litongjava.tio.core.maintain.ClientNodes;
import com.litongjava.tio.core.maintain.Groups;
import com.litongjava.tio.core.maintain.Ids;
import com.litongjava.tio.core.maintain.IpBlacklist;
import com.litongjava.tio.core.maintain.IpStats;
import com.litongjava.tio.core.maintain.Ips;
import com.litongjava.tio.core.maintain.Tokens;
import com.litongjava.tio.core.maintain.Users;
import com.litongjava.tio.core.ssl.SslConfig;
import com.litongjava.tio.core.stat.DefaultIpStatListener;
import com.litongjava.tio.core.stat.GroupStat;
import com.litongjava.tio.core.stat.IpStatListener;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.mapcache.ConcurrentMapCacheFactory;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.lock.MapWithLock;
import com.litongjava.tio.utils.lock.SetWithLock;
import com.litongjava.tio.utils.prop.MapWithLockPropSupport;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TioConfig
extends MapWithLockPropSupport {
    private static final Logger log = LoggerFactory.getLogger(TioConfig.class);
    public static final Set<ServerTioConfig> ALL_SERVER_GROUPCONTEXTS = new HashSet<ServerTioConfig>();
    public static final Set<ClientTioConfig> ALL_CLIENT_GROUPCONTEXTS = new HashSet<ClientTioConfig>();
    public static final Set<TioConfig> ALL_GROUPCONTEXTS = new HashSet<TioConfig>();
    public static final int READ_BUFFER_SIZE = EnvUtils.getInt((String)"tio.default.read.buffer.size", (int)8192);
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    public boolean isShortConnection = false;
    public SslConfig sslConfig = null;
    public boolean debug = false;
    public GroupStat groupStat = null;
    public boolean statOn = true;
    public boolean checkAttacks = true;
    public boolean ignoreDecodeFail = false;
    public boolean runOnAndroid = false;
    public PacketConverter packetConverter = null;
    private String charset = "utf-8";
    private int workerThreads = EnvUtils.getInt((String)"tio.core.threads", (int)(Runtime.getRuntime().availableProcessors() * 4));
    private CacheFactory cacheFactory;
    private RemovalListenerWrapper ipRemovalListenerWrapper;
    public long startTime = SystemTimer.currTime;
    public long heartbeatTimeout = 120000L;
    public boolean logWhenDecodeError = false;
    private int readBufferSize = READ_BUFFER_SIZE;
    private GroupListener groupListener = null;
    private AioId tioUuid = new DefaultTAioId();
    public ClientNodes clientNodes = new ClientNodes();
    public SetWithLock<ChannelContext> connections = new SetWithLock(new HashSet());
    public Groups groups = new Groups();
    public Users users = new Users();
    public Tokens tokens = new Tokens();
    public Ids ids = new Ids();
    public BsIds bsIds = new BsIds();
    public Ips ips = new Ips();
    public IpStats ipStats = new IpStats(this, null);
    protected String id;
    protected int maxDecodeErrorCountForIp = 10;
    protected String name = "Untitled";
    private IpStatListener ipStatListener = DefaultIpStatListener.me;
    private boolean isStopped = false;
    public IpBlacklist ipBlacklist = null;
    public MapWithLock<Integer, Packet> waitingResps = new MapWithLock(new HashMap());
    public boolean disgnostic = EnvUtils.getBoolean((String)"tio.core.diagnostic");

    public TioConfig() {
    }

    public TioConfig(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public TioConfig(CacheFactory cacheFactory, RemovalListenerWrapper<?> ipRemovalListenerWrapper) {
        this.cacheFactory = cacheFactory;
        this.ipRemovalListenerWrapper = ipRemovalListenerWrapper;
    }

    public TioConfig(String name) {
        this.name = name;
        try {
            Class.forName("android.os.Build");
            this.runOnAndroid = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public abstract AioHandler getAioHandler();

    public abstract AioListener getAioListener();

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    public String getId() {
        return this.id;
    }

    public AioId getTioUuid() {
        return this.tioUuid;
    }

    public MapWithLock<Integer, Packet> getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setGroupListener(GroupListener groupListener) {
        this.groupListener = groupListener;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 132476);
    }

    public void setShortConnection(boolean isShortConnection) {
        this.isShortConnection = isShortConnection;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void setTioUuid(AioId tioUuid) {
        this.tioUuid = tioUuid;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public IpStatListener getIpStatListener() {
        return this.ipStatListener;
    }

    public void setIpStatListener(IpStatListener ipStatListener) {
        this.ipStatListener = ipStatListener;
        this.setDefaultIpRemovalListenerWrapper();
    }

    public GroupStat getGroupStat() {
        return this.groupStat;
    }

    public abstract boolean isServer();

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public boolean isSsl() {
        return this.sslConfig != null;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public void setIpRemovalListenerWrapper(RemovalListenerWrapper<?> ipRemovalListenerWrapper) {
        this.ipRemovalListenerWrapper = ipRemovalListenerWrapper;
    }

    public RemovalListenerWrapper<?> getIpRemovalListenerWrapper() {
        return this.ipRemovalListenerWrapper;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDefaultIpRemovalListenerWrapper() {
        this.ipRemovalListenerWrapper = new RemovalListenerWrapper();
        IpStatMapCacheRemovalListener ipStatMapCacheRemovalListener = new IpStatMapCacheRemovalListener(this, this.ipStatListener);
        this.ipRemovalListenerWrapper.setListener((Object)ipStatMapCacheRemovalListener);
    }

    public void init() {
        if (this.cacheFactory == null) {
            this.cacheFactory = ConcurrentMapCacheFactory.INSTANCE;
        }
        if (this.ipRemovalListenerWrapper == null) {
            this.setDefaultIpRemovalListenerWrapper();
        }
        ALL_GROUPCONTEXTS.add(this);
        if (this instanceof ServerTioConfig) {
            ALL_SERVER_GROUPCONTEXTS.add((ServerTioConfig)this);
        } else {
            ALL_CLIENT_GROUPCONTEXTS.add((ClientTioConfig)this);
        }
        if (ALL_GROUPCONTEXTS.size() > 20) {
            log.warn("You have created {} TioConfig objects, you might be misusing t-io.", (Object)ALL_GROUPCONTEXTS.size());
        }
        this.id = ID_ATOMIC.incrementAndGet() + "";
        if (this.ipStats == null) {
            this.ipStats = new IpStats(this, null);
        }
    }
}

