/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core;

import com.litongjava.enhance.buffer.VirtualBuffer;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.pool.BufferPageUtils;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.core.task.DecodeTask;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import com.litongjava.tio.core.utils.TioUtils;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.CollUtil;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCompletionHandler
implements CompletionHandler<Integer, VirtualBuffer> {
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);
    private static Logger log = LoggerFactory.getLogger(ReadCompletionHandler.class);
    private ChannelContext channelContext = null;
    private DecodeTask decodeTask;

    public ReadCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.decodeTask = new DecodeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Integer result, VirtualBuffer virtualBuffer) {
        ByteBuffer byteBuffer = virtualBuffer.buffer();
        if (result > 0) {
            TioConfig tioConfig = this.channelContext.tioConfig;
            if (tioConfig.statOn) {
                tioConfig.groupStat.receivedBytes.addAndGet(result.intValue());
                tioConfig.groupStat.receivedTcps.incrementAndGet();
                this.channelContext.stat.receivedBytes.addAndGet(result.intValue());
                this.channelContext.stat.receivedTcps.incrementAndGet();
            }
            this.channelContext.stat.latestTimeOfReceivedByte = SystemTimer.currTime;
            if (CollUtil.isNotEmpty(tioConfig.ipStats.durationList)) {
                try {
                    for (Long v : tioConfig.ipStats.durationList) {
                        IpStat ipStat = tioConfig.ipStats.get(v, this.channelContext);
                        ipStat.getReceivedBytes().addAndGet(result.intValue());
                        ipStat.getReceivedTcps().incrementAndGet();
                        tioConfig.getIpStatListener().onAfterReceivedBytes(this.channelContext, result, ipStat);
                    }
                }
                catch (Exception e1) {
                    log.error(this.channelContext.toString(), (Throwable)e1);
                }
            }
            if (tioConfig.getAioListener() != null) {
                try {
                    tioConfig.getAioListener().onAfterReceivedBytes(this.channelContext, result);
                }
                catch (Exception e) {
                    log.error(this.channelContext.toString(), (Throwable)e);
                }
            }
            byteBuffer.flip();
            if (this.channelContext.sslFacadeContext == null) {
                try {
                    this.decodeTask.decode(this.channelContext, byteBuffer);
                }
                catch (Throwable e) {
                    log.error("Decode error", e);
                    virtualBuffer.clean();
                    Tio.close(this.channelContext, e, "unexpected decode error", ChannelContext.CloseCode.DECODE_ERROR);
                    return;
                }
            }
            ByteBuffer copiedByteBuffer = null;
            try {
                copiedByteBuffer = ByteBufferUtils.copy(byteBuffer);
                log.debug("{},Decrypt SSL data:{}", (Object)this.channelContext, (Object)copiedByteBuffer);
                this.channelContext.sslFacadeContext.getSslFacade().decrypt(copiedByteBuffer);
            }
            catch (Exception e) {
                log.error((Object)((Object)this.channelContext) + ", " + e.toString() + copiedByteBuffer, (Throwable)e);
                Tio.close(this.channelContext, (Throwable)e, e.toString(), ChannelContext.CloseCode.SSL_DECRYPT_ERROR);
            }
            if (TioUtils.checkBeforeIO(this.channelContext)) {
                this.read(byteBuffer, virtualBuffer);
            } else {
                virtualBuffer.clean();
            }
        } else {
            if (result == 0) {
                String message = "The length of the read data is 0";
                log.error("close {}, because {}", (Object)this.channelContext, (Object)message);
                try {
                    Tio.close(this.channelContext, null, message, ChannelContext.CloseCode.READ_COUNT_IS_ZERO);
                }
                finally {
                    virtualBuffer.clean();
                }
                return;
            }
            if (result < 0) {
                if (result == -1) {
                    String message = "The connection closed by peer";
                    if (DIAGNOSTIC_LOG_ENABLED) {
                        log.info("close {}, because {}", (Object)this.channelContext, (Object)message);
                    }
                    try {
                        Tio.close(this.channelContext, null, message, ChannelContext.CloseCode.CLOSED_BY_PEER);
                    }
                    finally {
                        virtualBuffer.clean();
                    }
                    return;
                }
                String message = "The length of the read data is less than -1";
                log.error("close {}, because {}", (Object)this.channelContext, (Object)message);
                try {
                    Tio.close(this.channelContext, null, "read result" + result, ChannelContext.CloseCode.READ_COUNT_IS_NEGATIVE);
                }
                catch (Exception e) {
                    virtualBuffer.clean();
                }
                return;
            }
        }
    }

    private void read(ByteBuffer readByteBuffer, VirtualBuffer virtualBuffer) {
        if (readByteBuffer.capacity() == this.channelContext.getReadBufferSize().intValue()) {
            readByteBuffer.position(0);
            readByteBuffer.limit(readByteBuffer.capacity());
        } else {
            virtualBuffer.clean();
            virtualBuffer = BufferPageUtils.allocate(this.channelContext.getReadBufferSize());
            readByteBuffer = virtualBuffer.buffer();
        }
        this.channelContext.asynchronousSocketChannel.read(readByteBuffer, virtualBuffer, this);
    }

    @Override
    public void failed(Throwable exc, VirtualBuffer virtualBuffer) {
        if (exc instanceof ClosedChannelException) {
            try {
                virtualBuffer.clean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Tio.close(this.channelContext, exc, "Failed to read data: " + exc.getClass().getName(), ChannelContext.CloseCode.READ_ERROR);
    }
}

