/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core;

import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.Objects;

public class Node
implements Comparable<Node> {
    private String ip;
    private int port;
    private Byte ssl = 1;

    public Node(String ip, int port) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            ip = "0.0.0.0";
        }
        this.setIp(ip);
        this.setPort(port);
    }

    @Override
    public int compareTo(Node other) {
        if (other == null) {
            return -1;
        }
        if (Objects.equals(this.ip, other.getIp()) && Objects.equals(this.port, other.getPort())) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Node other = (Node)obj;
        return this.ip.equals(other.getIp()) && this.port == other.getPort();
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return (this.ip + ":" + this.port).hashCode();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ip).append(":").append(this.port);
        return builder.toString();
    }

    public Byte getSsl() {
        return this.ssl;
    }

    public void setSsl(Byte ssl) {
        this.ssl = ssl;
    }
}

