/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core;

import com.litongjava.aio.Packet;
import com.litongjava.aio.PacketMeta;
import com.litongjava.tio.core.Node;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.ssl.SslFacadeContext;
import com.litongjava.tio.core.stat.ChannelStat;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.utils.hutool.CollUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.SetWithLock;
import com.litongjava.tio.utils.prop.MapWithLockPropSupport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelContext
extends MapWithLockPropSupport {
    private static final Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private static final String DEFAULT_ATTUBITE_KEY = "t-io-d-a-k";
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    public boolean isReconnect = false;
    public boolean isBind = false;
    public boolean logWhenDecodeError = false;
    public Long heartbeatTimeout = null;
    public Integer packetNeededLength = null;
    public TioConfig tioConfig = null;
    public final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    public SslFacadeContext sslFacadeContext;
    public String userId;
    private String token;
    private String bsId;
    public boolean isWaitingClose = false;
    public boolean isClosed = true;
    public boolean isRemoved = false;
    public boolean isVirtual = false;
    public boolean hasTempDir = false;
    public final ChannelStat stat = new ChannelStat();
    public AsynchronousSocketChannel asynchronousSocketChannel;
    private String id = null;
    private Node clientNode;
    private Node proxyClientNode = null;
    private Node serverNode;
    public SetWithLock<String> groups;
    private Integer readBufferSize = null;
    public CloseMeta closeMeta = new CloseMeta();
    private CloseCode closeCode = CloseCode.INIT_STATUS;
    public final Queue<Packet> sendQueue = new ConcurrentLinkedQueue<Packet>();
    public final AtomicBoolean isSending = new AtomicBoolean(false);

    public ChannelContext(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.init(tioConfig, asynchronousSocketChannel);
        if (tioConfig.sslConfig != null) {
            try {
                SslFacadeContext sslFacadeContext = new SslFacadeContext(this);
                if (tioConfig.isServer()) {
                    sslFacadeContext.beginHandshake();
                }
            }
            catch (Exception e) {
                log.error("\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this, "\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38" + e.getMessage(), CloseCode.SSL_ERROR_ON_HANDSHAKE);
                return;
            }
        }
    }

    public ChannelContext(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel, String ip, int port) {
        this.init(tioConfig, asynchronousSocketChannel, ip, port);
        if (tioConfig.sslConfig != null) {
            try {
                SslFacadeContext sslFacadeContext = new SslFacadeContext(this);
                if (tioConfig.isServer()) {
                    sslFacadeContext.beginHandshake();
                }
            }
            catch (Exception e) {
                log.error("\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this, "\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38" + e.getMessage(), CloseCode.SSL_ERROR_ON_HANDSHAKE);
                return;
            }
        }
    }

    public ChannelContext(TioConfig tioConfig) {
        this(tioConfig, tioConfig.getTioUuid().id());
    }

    public ChannelContext(TioConfig tioConfig, String id) {
        Node clientNode;
        this.isVirtual = true;
        this.tioConfig = tioConfig;
        this.clientNode = clientNode = new Node("127.0.0.1", 26254);
        this.id = id;
        if (StrUtil.isBlank((CharSequence)id)) {
            this.id = tioConfig.getTioUuid().id();
        }
    }

    private void assignAnUnknownClientNode() {
        Node clientNode = new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
        this.setClientNode(clientNode);
    }

    public Node createClientNode(AsynchronousSocketChannel asynchronousSocketChannel) throws IOException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)asynchronousSocketChannel.getRemoteAddress();
        Node clientNode = new Node(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        return clientNode;
    }

    public Node createClientNode(String clientIp, int port) {
        return new Node(clientIp, port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChannelContext other = (ChannelContext)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Object getAttribute() {
        return this.get();
    }

    public Object get() {
        return this.get(DEFAULT_ATTUBITE_KEY);
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public SetWithLock<String> getGroups() {
        return this.groups;
    }

    public String getId() {
        return this.id;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public String getToken() {
        return this.token;
    }

    public int hashCode() {
        if (StrUtil.isNotBlank((CharSequence)this.id)) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public void init(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.id = tioConfig.getTioUuid().id();
        this.setTioConfig(tioConfig);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.logWhenDecodeError = tioConfig.logWhenDecodeError;
    }

    public void init(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel, String clientIp, int port) {
        this.id = tioConfig.getTioUuid().id();
        this.setTioConfig(tioConfig);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel, clientIp, port);
        this.logWhenDecodeError = tioConfig.logWhenDecodeError;
    }

    public void processAfterSent(Packet packet, Boolean isSentSuccess) {
        block11: {
            isSentSuccess = isSentSuccess == null ? false : isSentSuccess;
            PacketMeta meta = packet.getMeta();
            if (meta != null) {
                CountDownLatch countDownLatch = meta.getCountDownLatch();
                countDownLatch.countDown();
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("{} Sent {}", (Object)this, (Object)packet.logstr());
                }
                if (this.sslFacadeContext != null && !this.sslFacadeContext.isHandshakeCompleted()) break block11;
                if (this.tioConfig.getAioListener() != null) {
                    try {
                        this.tioConfig.getAioListener().onAfterSent(this, packet, isSentSuccess);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                if (this.tioConfig.statOn) {
                    this.tioConfig.groupStat.sentPackets.incrementAndGet();
                    this.stat.sentPackets.incrementAndGet();
                }
                if (!CollUtil.isNotEmpty(this.tioConfig.ipStats.durationList)) break block11;
                try {
                    for (Long v : this.tioConfig.ipStats.durationList) {
                        IpStat ipStat = this.tioConfig.ipStats.get(v, this);
                        ipStat.getSentPackets().incrementAndGet();
                        this.tioConfig.getIpStatListener().onAfterSent(this, packet, isSentSuccess, ipStat);
                    }
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                Node clientNode = this.createClientNode(asynchronousSocketChannel);
                this.setClientNode(clientNode);
            }
            catch (IOException e) {
                log.error(e.getMessage());
                this.assignAnUnknownClientNode();
            }
        } else {
            log.error("assignAnUnknownClientNode:{}", (Object)asynchronousSocketChannel);
            this.assignAnUnknownClientNode();
        }
    }

    private void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel, String clientIp, int port) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        Node clientNode = this.createClientNode(clientIp, port);
        this.setClientNode(clientNode);
    }

    public void setAttribute(Object value) {
        this.set(value);
    }

    public void set(Object value) {
        this.set(DEFAULT_ATTUBITE_KEY, value);
    }

    public void setClientNode(Node clientNode) {
        if (!this.tioConfig.isShortConnection && this.clientNode != null) {
            this.tioConfig.clientNodes.remove(this);
        }
        this.clientNode = clientNode;
        if (this.tioConfig.isShortConnection) {
            return;
        }
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            this.tioConfig.clientNodes.put(this);
        }
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            this.assignAnUnknownClientNode();
        }
    }

    public void setTioConfig(TioConfig tioConfig) {
        this.tioConfig = tioConfig;
        if (tioConfig != null) {
            tioConfig.connections.add((Object)this);
        }
    }

    public void setPacketNeededLength(Integer packetNeededLength) {
        this.packetNeededLength = packetNeededLength;
    }

    public void setReconnect(boolean isReconnect) {
        this.isReconnect = isReconnect;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public void setSslFacadeContext(SslFacadeContext sslFacadeContext) {
        this.sslFacadeContext = sslFacadeContext;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this.serverNode != null) {
            sb.append("server:").append(this.serverNode.toString());
        } else {
            sb.append("server:").append("NULL");
        }
        if (this.clientNode != null) {
            sb.append(", client:").append(this.clientNode.toString());
        } else {
            sb.append(", client:").append("NULL");
        }
        if (this.isVirtual) {
            sb.append(", virtual");
        }
        return sb.toString();
    }

    public String getBsId() {
        return this.bsId;
    }

    public void setBsId(String bsId) {
        this.bsId = bsId;
    }

    public TioConfig getTioConfig() {
        return this.tioConfig;
    }

    public abstract boolean isServer();

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public Integer getReadBufferSize() {
        if (this.readBufferSize != null && this.readBufferSize > 0) {
            return this.readBufferSize;
        }
        return this.tioConfig.getReadBufferSize();
    }

    public void setReadBufferSize(Integer readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 132476);
    }

    public Node getProxyClientNode() {
        return this.proxyClientNode;
    }

    private void swithIpStat(IpStat oldIpStat, IpStat newIpStat, ChannelStat myStat) {
        oldIpStat.getHandledBytes().addAndGet(-myStat.getHandledBytes().get());
        oldIpStat.getHandledPacketCosts().addAndGet(-myStat.getHandledPacketCosts().get());
        oldIpStat.getHandledPackets().addAndGet(-myStat.getHandledPackets().get());
        oldIpStat.getReceivedBytes().addAndGet(-myStat.getReceivedBytes().get());
        oldIpStat.getReceivedPackets().addAndGet(-myStat.getReceivedPackets().get());
        oldIpStat.getReceivedTcps().addAndGet(-myStat.getReceivedTcps().get());
        oldIpStat.getRequestCount().addAndGet(-1);
        oldIpStat.getSentBytes().addAndGet(-myStat.getSentBytes().get());
        oldIpStat.getSentPackets().addAndGet(-myStat.getSentPackets().get());
        oldIpStat.getStart();
        newIpStat.getHandledBytes().addAndGet(myStat.getHandledBytes().get());
        newIpStat.getHandledPacketCosts().addAndGet(myStat.getHandledPacketCosts().get());
        newIpStat.getHandledPackets().addAndGet(myStat.getHandledPackets().get());
        newIpStat.getReceivedBytes().addAndGet(myStat.getReceivedBytes().get());
        newIpStat.getReceivedPackets().addAndGet(myStat.getReceivedPackets().get());
        newIpStat.getReceivedTcps().addAndGet(myStat.getReceivedTcps().get());
        newIpStat.getRequestCount().addAndGet(1);
        newIpStat.getSentBytes().addAndGet(myStat.getSentBytes().get());
        newIpStat.getSentPackets().addAndGet(myStat.getSentPackets().get());
        newIpStat.getStart();
    }

    public void setProxyClientNode(Node proxyClientNode) {
        this.proxyClientNode = proxyClientNode;
        if (proxyClientNode != null && !Objects.equals(proxyClientNode.getIp(), this.clientNode.getIp()) && CollUtil.isNotEmpty(this.tioConfig.ipStats.durationList)) {
            try {
                for (Long v : this.tioConfig.ipStats.durationList) {
                    IpStat oldIpStat = this.tioConfig.ipStats._get(v, this, true, false);
                    IpStat newIpStat = this.tioConfig.ipStats.get(v, this);
                    ChannelStat myStat = this.stat;
                    this.swithIpStat(oldIpStat, newIpStat, myStat);
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public CloseCode getCloseCode() {
        return this.closeCode;
    }

    public void setCloseCode(CloseCode closeCode) {
        this.closeCode = closeCode;
    }

    public String getClientIpAndPort() {
        Node client = this.getProxyClientNode();
        if (client == null) {
            client = this.getClientNode();
        }
        String ip = client.getIp();
        int port = client.getPort();
        return ip + ':' + port;
    }

    public static enum CloseCode {
        NO_CODE((byte)1),
        READ_ERROR((byte)2),
        WRITER_ERROR((byte)3),
        DECODE_ERROR((byte)4),
        CHANNEL_NOT_OPEN((byte)5),
        READ_COUNT_IS_ZERO((byte)6),
        CLOSED_BY_PEER((byte)7),
        READ_COUNT_IS_NEGATIVE((byte)8),
        WRITE_COUNT_IS_NEGATIVE((byte)9),
        SERVER_CONNECTION((byte)9),
        HEARTBEAT_TIMEOUT((byte)10),
        CLIENT_CONNECTION_FAIL((byte)80),
        SSL_ERROR_ON_HANDSHAKE((byte)50),
        SSL_SESSION_CLOSED((byte)51),
        SSL_ENCRYPTION_ERROR((byte)52),
        SSL_DECRYPT_ERROR((byte)53),
        USER_CODE_0((byte)100),
        USER_CODE_1((byte)101),
        USER_CODE_2((byte)102),
        USER_CODE_3((byte)103),
        USER_CODE_4((byte)104),
        USER_CODE_5((byte)105),
        USER_CODE_6((byte)106),
        USER_CODE_7((byte)107),
        USER_CODE_8((byte)108),
        USER_CODE_9((byte)109),
        USER_CODE_10((byte)110),
        INIT_STATUS((byte)-57),
        OTHER_ERROR((byte)-56),
        PACKET_TOO_LARGE((byte)-55),
        CLOSE_BY_ERROR((byte)-55);

        Byte value;

        public static CloseCode from(Byte value) {
            CloseCode[] values;
            for (CloseCode v : values = CloseCode.values()) {
                if (!Objects.equals(v.value, value)) continue;
                return v;
            }
            return null;
        }

        private CloseCode(Byte value) {
            this.value = value;
        }

        public Byte getValue() {
            return this.value;
        }

        public void setValue(Byte value) {
            this.value = value;
        }
    }

    public static class CloseMeta {
        public Throwable throwable;
        public String remark;
        public boolean isNeedRemove;

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean isNeedRemove() {
            return this.isNeedRemove;
        }

        public void setNeedRemove(boolean isNeedRemove) {
            this.isNeedRemove = isNeedRemove;
        }
    }
}

