/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.client;

import com.litongjava.tio.client.ClientChannelContext;
import com.litongjava.tio.client.TioClient;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.thread.pool.AbstractSynRunnable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnRunnable
extends AbstractSynRunnable {
    private static Logger log = LoggerFactory.getLogger(ReconnRunnable.class);
    ClientChannelContext channelContext = null;
    TioClient tioClient = null;

    public ReconnRunnable(ClientChannelContext channelContext, TioClient tioClient, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioClient = tioClient;
    }

    public boolean isNeededExecute() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        this.channelContext.getReconnCount().incrementAndGet();
        ReentrantReadWriteLock closeLock = this.channelContext.closeLock;
        ReentrantReadWriteLock.WriteLock writeLock = closeLock.writeLock();
        writeLock.lock();
        try {
            if (!this.channelContext.isClosed) {
                return;
            }
            long start = SystemTimer.currTime;
            this.tioClient.reconnect(this.channelContext, 2);
            long end = SystemTimer.currTime;
            long iv = end - start;
            log.error("{}, \u7b2c{}\u6b21\u91cd\u8fde,\u91cd\u8fde\u8017\u65f6:{} ms", new Object[]{this.channelContext, this.channelContext.getReconnCount(), iv});
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

