/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.client;

import com.litongjava.tio.client.ClientGroupStat;
import com.litongjava.tio.client.ConnectionCompletionHandler;
import com.litongjava.tio.client.DefaultClientAioListener;
import com.litongjava.tio.client.ReconnConf;
import com.litongjava.tio.client.intf.ClientAioHandler;
import com.litongjava.tio.client.intf.ClientAioListener;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.intf.AioHandler;
import com.litongjava.tio.core.intf.AioListener;
import com.litongjava.tio.core.ssl.SslConfig;
import com.litongjava.tio.utils.lock.SetWithLock;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTioConfig
extends TioConfig {
    static Logger log = LoggerFactory.getLogger(ClientTioConfig.class);
    private ClientAioHandler clientAioHandler = null;
    private ClientAioListener clientAioListener = null;
    protected ReconnConf reconnConf;
    private ConnectionCompletionHandler connectionCompletionHandler = new ConnectionCompletionHandler();
    public final SetWithLock<ChannelContext> connecteds = new SetWithLock(new HashSet());
    public final SetWithLock<ChannelContext> closeds = new SetWithLock(new HashSet());

    public ClientTioConfig(ClientAioHandler aioHandler, ClientAioListener aioListener) {
        this(aioHandler, aioListener, null);
    }

    public ClientTioConfig(ClientAioHandler aioHandler, ClientAioListener aioListener, ReconnConf reconnConf) {
        this.groupStat = new ClientGroupStat();
        this.setClientAioHandler(aioHandler);
        this.setClientAioListener(aioListener);
        this.reconnConf = reconnConf;
        this.init();
    }

    public void useSsl() throws Exception {
        SslConfig sslConfig = SslConfig.forClient();
        this.setSslConfig(sslConfig);
    }

    @Override
    public AioHandler getAioHandler() {
        return this.getClientAioHandler();
    }

    @Override
    public AioListener getAioListener() {
        return this.getClientAioListener();
    }

    public ClientAioHandler getClientAioHandler() {
        return this.clientAioHandler;
    }

    public ClientAioListener getClientAioListener() {
        return this.clientAioListener;
    }

    public ConnectionCompletionHandler getConnectionCompletionHandler() {
        return this.connectionCompletionHandler;
    }

    public void setClientAioHandler(ClientAioHandler clientAioHandler) {
        this.clientAioHandler = clientAioHandler;
    }

    public void setClientAioListener(ClientAioListener clientAioListener) {
        this.clientAioListener = clientAioListener;
        if (this.clientAioListener == null) {
            this.clientAioListener = new DefaultClientAioListener();
        }
    }

    public void setConnectionCompletionHandler(ConnectionCompletionHandler connectionCompletionHandler) {
        this.connectionCompletionHandler = connectionCompletionHandler;
    }

    public void setReconnConf(ReconnConf reconnConf) {
        this.reconnConf = reconnConf;
    }

    public ReconnConf getReconnConf() {
        return this.reconnConf;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public String toString() {
        return "ClientTioConfig [name=" + this.name + "]";
    }
}

