/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.litongjava.tio.http.common.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpResponseUtils {
    public static void toTioHttpResponse(Response okHttpResponse, HttpResponse httpResponse) {
        if (okHttpResponse == null || httpResponse == null) {
            return;
        }
        httpResponse.setStatus(okHttpResponse.code(), okHttpResponse.message());
        Headers responseHeaders = okHttpResponse.headers();
        for (String name : responseHeaders.names()) {
            httpResponse.addHeader(name.toLowerCase(), responseHeaders.get(name));
        }
        ResponseBody body = okHttpResponse.body();
        if (body != null) {
            try (InputStream byteStream = body.byteStream();
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int read;
                byte[] buffer = new byte[2048];
                while ((read = byteStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                httpResponse.setBody(baos.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

