/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.litongjava.tio.http.common.HttpMethod;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.UploadFile;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpRequestUtils.class);

    public static Request buildOkHttpRequest(String prefix, HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        HttpMethod requestMethod = requestLine.getMethod();
        String pathAndQuery = requestLine.getPathAndQuery();
        String targetUrl = prefix + pathAndQuery;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(targetUrl);
        Map requestHeaders = httpRequest.getHeaders();
        Headers headers = Headers.of((Map)requestHeaders);
        requestBuilder.headers(headers);
        if (HttpMethod.GET.equals((Object)requestMethod)) {
            requestBuilder.get();
        } else if (HttpMethod.POST.equals((Object)requestMethod)) {
            requestBuilder.post(OkHttpRequestUtils.buildRequestBody(httpRequest));
        } else if (HttpMethod.PUT.equals((Object)requestMethod)) {
            requestBuilder.put(OkHttpRequestUtils.buildRequestBody(httpRequest));
        } else if (HttpMethod.DELETE.equals((Object)requestMethod)) {
            requestBuilder.delete(OkHttpRequestUtils.buildRequestBody(httpRequest));
        } else {
            log.error("unknows method:{}", (Object)requestMethod);
        }
        return requestBuilder.build();
    }

    private static RequestBody buildRequestBody(HttpRequest httpRequest) {
        String contentType = httpRequest.getContentType();
        if (contentType != null) {
            if (contentType.startsWith("application/json")) {
                MediaType mediaType = MediaType.parse((String)contentType);
                return RequestBody.create((MediaType)mediaType, (String)httpRequest.getBodyString());
            }
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                FormBody.Builder builder = new FormBody.Builder();
                Map params = httpRequest.getParams();
                for (Map.Entry e : params.entrySet()) {
                    builder.add((String)e.getKey(), (String)((Object[])e.getValue())[0]);
                }
                return builder.build();
            }
            if (contentType.startsWith("multipart/form-data")) {
                MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                Map params = httpRequest.getParams();
                for (Map.Entry e : params.entrySet()) {
                    Object value = ((Object[])e.getValue())[0];
                    if (value instanceof String) {
                        builder.addFormDataPart((String)e.getKey(), (String)value);
                        continue;
                    }
                    UploadFile uploadFile = httpRequest.getUploadFile((String)e.getKey());
                    RequestBody fileBody = RequestBody.create((byte[])uploadFile.getData());
                    builder.addFormDataPart((String)e.getKey(), uploadFile.getName(), fileBody);
                }
                return builder.build();
            }
            MediaType mediaType = MediaType.parse((String)contentType);
            return RequestBody.create((MediaType)mediaType, (String)httpRequest.getBodyString());
        }
        MediaType mediaType = MediaType.parse((String)"text/plain");
        return RequestBody.create((MediaType)mediaType, (String)"");
    }
}

