/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpResource;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class HttpResourceUtils {
    public static HttpResource getResource(String pageRoot, String path) {
        HttpResource httpResource = null;
        if (pageRoot != null) {
            String complatePath;
            File file;
            if (StrUtil.endWith((CharSequence)path, (CharSequence)"/")) {
                path = path + "index.html";
            }
            if ((file = new File(complatePath = pageRoot + path)).exists()) {
                httpResource = new HttpResource(path, null, file);
            }
        }
        return httpResource;
    }

    public static HttpResponse buildFileResponse(HttpResponse httpResponse, HttpResource httpResource) throws IOException {
        File file = httpResource.getFile();
        byte[] fileContent = Files.readAllBytes(file.toPath());
        String extension = HttpResourceUtils.getFileExtension(file.getName());
        HttpResponse response = Resps.bytes((HttpResponse)httpResponse, (byte[])fileContent, (String)extension);
        response.setStaticRes(true);
        response.setLastModified(HeaderValue.from((String)String.valueOf(file.lastModified())));
        return response;
    }

    private static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex > 0 ? filename.substring(dotIndex + 1) : "";
    }
}

