/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.ResponseHeaderKey;
import com.litongjava.tio.http.server.util.Resps;
import java.io.File;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class HttpFileDataUtils {
    private static final long ZERO_COPY_THRESHOLD = 0x100000L;
    private static final DateTimeFormatter HTTP_DATE_FORMAT = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.US).withZone(ZoneId.of("GMT"));

    public static void setCacheHeaders(HttpResponse response, long lastModified, String etag, String contentType, String suffix) {
        if ("m3u8".equalsIgnoreCase(suffix)) {
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            return;
        }
        String lastModStr = HTTP_DATE_FORMAT.format(Instant.ofEpochMilli(lastModified));
        response.setHeader("Last-Modified", lastModStr);
        response.setHeader("ETag", etag);
        String cacheControl = HttpFileDataUtils.getCacheControlForContentType(contentType);
        response.setHeader("Cache-Control", cacheControl);
        long expiresTime = System.currentTimeMillis() + 31536000000L;
        String expiresStr = HTTP_DATE_FORMAT.format(Instant.ofEpochMilli(expiresTime));
        response.setHeader("Expires", expiresStr);
        response.setHeader("Vary", "Accept-Encoding");
    }

    public static boolean isClientCacheValid(HttpRequest request, long lastModified, String etag) {
        String ifNoneMatch = request.getHeader("if-none-match");
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            return true;
        }
        String ifModifiedSince = request.getHeader("if-modified-since");
        if (ifModifiedSince != null) {
            try {
                ZonedDateTime clientDate = ZonedDateTime.parse(ifModifiedSince, HTTP_DATE_FORMAT);
                Instant fileInstant = Instant.ofEpochMilli(lastModified);
                if (!fileInstant.isAfter(clientDate.toInstant())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getCacheControlForContentType(String contentType) {
        if (contentType == null) {
            return "public, max-age=3600";
        }
        if (contentType.startsWith("image/")) {
            return "public, max-age=31536000, immutable";
        }
        if (contentType.startsWith("video/") || contentType.startsWith("audio/")) {
            return "public, max-age=31536000, immutable";
        }
        if (contentType.equals("text/css") || contentType.equals("application/javascript")) {
            return "public, max-age=31536000, immutable";
        }
        if (contentType.startsWith("font/") || contentType.equals("application/font-woff") || contentType.equals("application/font-woff2")) {
            return "public, max-age=31536000, immutable";
        }
        if (contentType.startsWith("text/")) {
            return "public, max-age=3600";
        }
        return "public, max-age=86400";
    }

    public static String generateETag(File file, long lastModified, long fileLength) {
        try {
            String input = file.getAbsolutePath() + fileLength + lastModified;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (byte b : hash) {
                sb.append(String.format("%02x", b));
            }
            sb.append('\"');
            return sb.toString();
        }
        catch (Exception e) {
            return "\"" + lastModified + "-" + fileLength + "\"";
        }
    }

    public static HttpResponse handleRangeRequest(HttpResponse response, File file, String range, long fileLength, String contentType) {
        String rangeValue = range.substring("bytes=".length());
        String[] parts = rangeValue.split("-");
        try {
            long end;
            long start = parts[0].isEmpty() ? 0L : Long.parseLong(parts[0]);
            long l = end = parts.length > 1 && !parts[1].isEmpty() ? Long.parseLong(parts[1]) : fileLength - 1L;
            if (start > end || end >= fileLength) {
                response.setStatus(416);
                response.setHeader("Content-Range", "bytes */" + fileLength);
                return response;
            }
            long contentLength = end - start + 1L;
            if (contentLength >= 0x100000L) {
                HttpFileDataUtils.prepareZeroCopyResponse(response, file, start, end, contentType, true, fileLength);
            } else {
                byte[] data = HttpFileDataUtils.readFileRange(file, start, contentLength);
                if (data == null) {
                    response.setStatus(500);
                    return response;
                }
                response.setStatus(206);
                response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + fileLength);
                response.setHeader("Accept-Ranges", "bytes");
                response.setHeader(ResponseHeaderKey.Content_Length, String.valueOf(contentLength));
                response.setSkipAddContentLength(false);
                Resps.bytesWithContentType((HttpResponse)response, (byte[])data, (String)contentType);
                response.setSkipGzipped(false);
            }
        }
        catch (Exception e) {
            response.setStatus(416);
            response.setHeader("Content-Range", "bytes */" + fileLength);
        }
        return response;
    }

    public static HttpResponse handleFullFileRequest(HttpResponse response, File file, long fileLength, String contentType) {
        if (fileLength >= 0x100000L) {
            HttpFileDataUtils.prepareZeroCopyResponse(response, file, 0L, fileLength - 1L, contentType, false, fileLength);
        } else {
            byte[] fileData = HttpFileDataUtils.readFullFile(file);
            if (fileData == null) {
                response.setStatus(500);
                return response;
            }
            response.setHeader("Accept-Ranges", "bytes");
            Resps.bytesWithContentType((HttpResponse)response, (byte[])fileData, (String)contentType);
            if (contentType != null && (contentType.startsWith("video/") || contentType.startsWith("audio/"))) {
                response.setSkipGzipped(true);
            } else {
                response.setSkipGzipped(false);
            }
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFileRange(File file, long start, long length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFullFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpResponse prepareZeroCopyResponse(HttpResponse response, File file, long start, long end, String contentType, boolean isRange, long fileLength) {
        long contentLength = end - start + 1L;
        if (isRange) {
            response.setStatus(206);
            response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + fileLength);
        } else {
            response.setStatus(200);
        }
        response.setHeader("Accept-Ranges", "bytes");
        if (contentType != null) {
            response.setHeader("Content-Type", contentType);
        }
        response.setHeader(ResponseHeaderKey.Content_Length, String.valueOf(contentLength));
        response.setSkipAddContentLength(false);
        response.setFileBody(file);
        response.setSkipGzipped(false);
        return response;
    }
}

