/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.token;

import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import java.util.function.Predicate;

public class AuthTokenInterceptor
implements HttpRequestInterceptor {
    private Object body = null;
    private Predicate<String> validateTokenLogic;

    public AuthTokenInterceptor() {
    }

    public AuthTokenInterceptor(Object body) {
        this.body = body;
    }

    public AuthTokenInterceptor(Predicate<String> validateTokenLogic) {
        this.validateTokenLogic = validateTokenLogic;
    }

    public AuthTokenInterceptor(Object body, Predicate<String> validateTokenLogic) {
        this.body = body;
        this.validateTokenLogic = validateTokenLogic;
    }

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine requestLine, HttpResponse responseFromCache) {
        if (this.validateTokenLogic != null) {
            String[] split;
            String token = request.getParam("token");
            if (token == null) {
                token = request.getHeader("token");
            }
            if (token != null && this.validateTokenLogic.test(token)) {
                return null;
            }
            String authorization = request.getHeader("authorization");
            if (authorization != null && this.validateTokenLogic.test(token = (split = authorization.split(" ")).length > 1 ? split[1] : split[0])) {
                return null;
            }
        }
        HttpResponse response = TioRequestContext.getResponse();
        response.setStatus(HttpResponseStatus.C401);
        if (this.body != null) {
            response.setJson(this.body);
        }
        return response;
    }

    public void doAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost) throws Exception {
    }
}

