/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.spring;

import com.litongjava.context.Context;
import com.litongjava.tio.boot.TioApplication;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.spring.SpringBootArgs;
import com.litongjava.tio.boot.spring.TioBootRouteProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;

public class TioBootWebServer
implements WebServer {
    private static final Logger log = LoggerFactory.getLogger(TioBootWebServer.class);
    private static final int ERROR_NO_EACCES = -13;
    private final TioBootServer tioBootServer;
    private final Duration lifecycleTimeout;
    private List<TioBootRouteProvider> routeProviders = Collections.emptyList();
    private ReactorHttpHandlerAdapter handler;
    private Context context;

    public TioBootWebServer(TioBootServer tioBootServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        Assert.notNull((Object)tioBootServer, (String)"tioBootServer must not be null");
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter must not be null");
        this.tioBootServer = tioBootServer;
        this.lifecycleTimeout = lifecycleTimeout;
        this.handler = handlerAdapter;
    }

    public void setRouteProviders(List<TioBootRouteProvider> routeProviders) {
        this.routeProviders = routeProviders;
    }

    public void start() throws WebServerException {
        Class<?> primarySource = SpringBootArgs.getPrimarySource();
        String[] args = SpringBootArgs.getArgs();
        this.context = TioApplication.run(primarySource, args);
        for (TioBootRouteProvider provider : this.routeProviders) {
            log.info("{}", (Object)provider);
        }
    }

    public void stop() throws WebServerException {
        try {
            this.context.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.context.getPort();
    }
}

