/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.spring;

import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.spring.TioBootRouteProvider;
import com.litongjava.tio.boot.spring.TioBootServerCustomizer;
import com.litongjava.tio.boot.spring.TioBootWebServer;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;

public class TioBootReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private Set<TioBootServerCustomizer> serverCustomizers = new LinkedHashSet<TioBootServerCustomizer>();
    private List<TioBootRouteProvider> routeProviders = new ArrayList<TioBootRouteProvider>();
    private Duration lifecycleTimeout;
    private boolean useForwardHeaders;
    private ReactorResourceFactory resourceFactory;

    public TioBootReactiveWebServerFactory() {
    }

    public TioBootReactiveWebServerFactory(int port) {
        super(port);
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        TioBootServer tioBootServer = this.createTioBootServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        TioBootWebServer webServer = this.createTioBootWebServer(tioBootServer, handlerAdapter, this.lifecycleTimeout);
        webServer.setRouteProviders(this.routeProviders);
        return webServer;
    }

    TioBootWebServer createTioBootWebServer(TioBootServer tioBootServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        return new TioBootWebServer(tioBootServer, handlerAdapter, lifecycleTimeout);
    }

    public Collection<TioBootServerCustomizer> getServerCustomizers() {
        return this.serverCustomizers;
    }

    public void setServerCustomizers(Collection<? extends TioBootServerCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, (String)"ServerCustomizers must not be null");
        this.serverCustomizers = new LinkedHashSet<TioBootServerCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(TioBootServerCustomizer ... serverCustomizers) {
        Assert.notNull((Object)serverCustomizers, (String)"ServerCustomizer must not be null");
        this.serverCustomizers.addAll(Arrays.asList(serverCustomizers));
    }

    public void addRouteProviders(TioBootRouteProvider ... routeProviders) {
        Assert.notNull((Object)routeProviders, (String)"TioBootRouteProvider must not be null");
        this.routeProviders.addAll(Arrays.asList(routeProviders));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public void setResourceFactory(ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    private TioBootServer createTioBootServer() {
        TioBootServer server = TioBootServer.create();
        return this.applyCustomizers(server);
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private TioBootServer applyCustomizers(TioBootServer server) {
        for (TioBootServerCustomizer customizer : this.serverCustomizers) {
            server = customizer.apply(server);
        }
        return server;
    }
}

