/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.server;

import com.litongjava.aio.ByteBufferPacket;
import com.litongjava.aio.BytePacket;
import com.litongjava.aio.Packet;
import com.litongjava.aio.StringPacket;
import com.litongjava.tio.boot.decode.TioDecodeExceptionHandler;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpRequestDecoder;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponsePacket;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.http.server.HttpServerAioHandler;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.websocket.common.WebSocketRequest;
import com.litongjava.tio.websocket.common.WebSocketResponse;
import com.litongjava.tio.websocket.common.WebSocketSessionContext;
import com.litongjava.tio.websocket.server.WebsocketServerAioHandler;
import com.litongjava.tio.websocket.server.WebsocketServerConfig;
import com.litongjava.tio.websocket.server.handler.IWebSocketHandler;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioBootServerHandler
implements ServerAioHandler {
    private static final Logger log = LoggerFactory.getLogger(TioBootServerHandler.class);
    public static final int MINIMUM_HTTP_HEADER_LENGTH = 32;
    protected WebsocketServerConfig defaultServerConfig;
    private WebsocketServerAioHandler defaultServerAioHandler;
    protected HttpConfig httpConfig;
    private HttpServerAioHandler httpServerAioHandler;
    private ServerAioHandler serverAioHandler;
    private TioDecodeExceptionHandler tioDecodeExceptionHandler;

    public TioBootServerHandler(WebsocketServerConfig wsServerConfig, IWebSocketHandler websocketHandler, HttpConfig httpConfig, ITioHttpRequestHandler requestHandler, ServerAioHandler serverAioHandler, TioDecodeExceptionHandler tioDecodeExceptionHandler) {
        this.defaultServerConfig = wsServerConfig;
        this.defaultServerAioHandler = new WebsocketServerAioHandler(wsServerConfig, websocketHandler);
        this.httpConfig = httpConfig;
        this.httpServerAioHandler = new HttpServerAioHandler(httpConfig, requestHandler);
        this.serverAioHandler = serverAioHandler;
        this.tioDecodeExceptionHandler = tioDecodeExceptionHandler;
    }

    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws Exception {
        HttpRequest request;
        WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
        if (wsSessionContext.isHandshaked()) {
            return this.defaultServerAioHandler.decode(buffer, limit, position, readableLength, channelContext);
        }
        if (readableLength < 32) {
            if (this.serverAioHandler != null) {
                return this.serverAioHandler.decode(buffer, limit, position, readableLength, channelContext);
            }
            return null;
        }
        try {
            request = HttpRequestDecoder.decode((ByteBuffer)buffer, (int)limit, (int)position, (int)readableLength, (ChannelContext)channelContext, (HttpConfig)this.httpConfig);
        }
        catch (TioDecodeException e) {
            if (this.serverAioHandler != null) {
                return this.serverAioHandler.decode(buffer, limit, position, readableLength, channelContext);
            }
            if (this.tioDecodeExceptionHandler != null) {
                this.tioDecodeExceptionHandler.handle(buffer, channelContext, this.httpConfig, e);
            } else {
                log.error("Decode exception occurred", (Throwable)e);
            }
            return null;
        }
        if (request == null) {
            return null;
        }
        String upgradeHeader = request.getHeader("upgrade");
        if ("websocket".equalsIgnoreCase(upgradeHeader)) {
            HttpResponse httpResponse = WebsocketServerAioHandler.upgradeWebSocketProtocol((HttpRequest)request, (ChannelContext)channelContext);
            if (httpResponse == null) {
                throw new TioDecodeException("Failed to upgrade HTTP protocol to WebSocket protocol.");
            }
            wsSessionContext.setHandshakeRequest(request);
            wsSessionContext.setHandshakeResponse(httpResponse);
            WebSocketRequest wsRequestPacket = new WebSocketRequest();
            wsRequestPacket.setHandShake(true);
            return wsRequestPacket;
        }
        channelContext.setAttribute("tio_request_key", (Object)request);
        return request;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        if (packet instanceof HttpResponse) {
            return this.httpServerAioHandler.encode(packet, tioConfig, channelContext);
        }
        if (packet instanceof HttpResponsePacket) {
            HttpResponsePacket responsePacket = (HttpResponsePacket)packet;
            return responsePacket.toByteBuffer(tioConfig);
        }
        if (packet instanceof WebSocketResponse) {
            return this.defaultServerAioHandler.encode(packet, tioConfig, channelContext);
        }
        if (this.serverAioHandler != null) {
            return this.serverAioHandler.encode(packet, tioConfig, channelContext);
        }
        if (packet instanceof BytePacket) {
            byte[] bytes = ((BytePacket)packet).getBytes();
            return ByteBuffer.wrap(bytes);
        }
        if (packet instanceof ByteBufferPacket) {
            return ((ByteBufferPacket)packet).getByteBuffer();
        }
        if (packet instanceof StringPacket) {
            try {
                byte[] bytes = ((StringPacket)packet).getBody().getBytes(tioConfig.getCharset());
                return ByteBuffer.wrap(bytes);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        log.warn("Unknown packet type: {}", (Object)packet.getClass().getName());
        return null;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        if (packet instanceof HttpRequest) {
            this.httpServerAioHandler.handler(packet, channelContext);
        } else if (packet instanceof WebSocketRequest) {
            this.defaultServerAioHandler.handler(packet, channelContext);
        } else if (this.serverAioHandler != null) {
            this.serverAioHandler.handler(packet, channelContext);
        } else {
            log.warn("No handler available for packet type: {}", (Object)packet.getClass().getName());
        }
    }
}

