/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.satoken;

import cn.dev33.satoken.stp.StpUtil;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import com.litongjava.tio.http.server.util.Resps;
import java.util.function.Predicate;

public class AuthSaTokenInterceptor
implements HttpRequestInterceptor {
    private Object body = null;
    private Predicate<String> validateTokenLogic;

    public AuthSaTokenInterceptor() {
    }

    public AuthSaTokenInterceptor(Object body) {
        this.body = body;
    }

    public AuthSaTokenInterceptor(Predicate<String> validateTokenLogic) {
        this.validateTokenLogic = validateTokenLogic;
    }

    public AuthSaTokenInterceptor(Object body, Predicate<String> validateTokenLogic) {
        this.body = body;
        this.validateTokenLogic = validateTokenLogic;
    }

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine requestLine, HttpResponse responseFromCache) {
        if (this.validateTokenLogic != null) {
            String[] split;
            String token = request.getHeader("token");
            if (token != null && this.validateTokenLogic.test(token)) {
                return null;
            }
            String authorization = request.getHeader("authorization");
            if (authorization != null && (split = authorization.split(" ")).length > 1 && this.validateTokenLogic.test(split[1])) {
                return null;
            }
        }
        if (StpUtil.isLogin()) {
            return null;
        }
        HttpResponse response = TioRequestContext.getResponse();
        response.setStatus(HttpResponseStatus.C401);
        if (this.body != null) {
            Resps.json((HttpResponse)response, (Object)this.body);
        }
        return response;
    }

    public void doAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost) throws Exception {
    }
}

