/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.utils;

import com.litongjava.tio.boot.http.handler.controller.TioBootHttpControllerRouter;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.hutool.Validator;
import java.lang.reflect.Method;

public class TioHttpControllerUtils {
    public static Method getActionMethod(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig, TioBootHttpControllerRouter router) {
        Method method = null;
        String path = requestLine.path;
        if (router != null && (method = router.getActionByPath(path, request.getMethod().toString(), request)) == null && "/".equals(path)) {
            method = router.getActionByPath("", request.getMethod().toString(), request);
        }
        if (method == null && StrUtil.isNotBlank((CharSequence)httpConfig.getWelcomeFile()) && StrUtil.endWith((CharSequence)path, (CharSequence)"/")) {
            path = path + httpConfig.getWelcomeFile();
            requestLine.setPath(path);
            if (router != null) {
                method = router.getActionByPath(path, request.getMethod().toString(), request);
                path = requestLine.path;
            }
        }
        return method;
    }

    public static String getDomain(HttpRequest request) {
        String[] dms;
        String domain = request.getDomain();
        boolean isip = Validator.isIpv4((String)domain);
        if (!isip && domain != null && (dms = StrUtil.split((String)domain, (String)".")).length > 2) {
            domain = "." + dms[dms.length - 2] + "." + dms[dms.length - 1];
        }
        return domain;
    }
}

