/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.session;

import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.session.HttpSession;
import com.litongjava.tio.http.common.session.limiter.SessionRateLimiter;
import com.litongjava.tio.http.common.session.limiter.SessionRateVo;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.cache.AbsCache;
import java.io.Serializable;

public class SessionLimit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse check(HttpRequest request, String path, HttpConfig httpConfig, AbsCache sessionRateLimiterCache) {
        SessionRateLimiter sessionRateLimiter = httpConfig.sessionRateLimiter;
        if (sessionRateLimiter != null) {
            HttpSession httpSession = request.getHttpSession();
            String key = path + "?" + httpSession.getId();
            SessionRateVo sessionRateVo = (SessionRateVo)sessionRateLimiterCache.get(key, SessionRateVo.class);
            if (sessionRateVo == null) {
                HttpSession httpSession2 = httpSession;
                synchronized (httpSession2) {
                    sessionRateVo = (SessionRateVo)sessionRateLimiterCache.get(key, SessionRateVo.class);
                    if (sessionRateVo == null) {
                        sessionRateVo = SessionRateVo.create((String)path);
                        sessionRateLimiterCache.put(key, (Serializable)sessionRateVo);
                        return null;
                    }
                }
            }
            HttpResponse response = null;
            if (!sessionRateLimiter.allow(request, sessionRateVo)) {
                response = sessionRateLimiter.response(request, sessionRateVo);
            }
            sessionRateVo.setLastAccessTime(SystemTimer.currTime);
            sessionRateVo.getAccessCount().incrementAndGet();
            return response;
        }
        return null;
    }
}

