/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.internal;

import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.session.limiter.SessionRateLimiter;
import com.litongjava.tio.http.common.session.limiter.SessionRateVo;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.environment.EnvUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class TioServerSessionRateLimiter
implements SessionRateLimiter {
    private static final int MAX_REQUESTS_PER_SECOND = EnvUtils.getInt((String)"http.max.requests.per.second", (int)10);

    public boolean allow(HttpRequest request, SessionRateVo sessionRateVo) {
        long lastAccessTime;
        AtomicInteger accessCount = sessionRateVo.getAccessCount();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastAccessTime = sessionRateVo.getLastAccessTime()) < 1000L) {
            return accessCount.get() < MAX_REQUESTS_PER_SECOND;
        }
        accessCount.set(0);
        return true;
    }

    public HttpResponse response(HttpRequest request, SessionRateVo sessionRateVo) {
        HttpResponse httpResponse = Resps.txt((HttpRequest)request, (String)"Too Many Requests");
        httpResponse.setStatus(429);
        return httpResponse;
    }
}

