/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.internal;

import com.litongjava.hook.HookCan;
import com.litongjava.tio.boot.cache.StaticResourcesCache;
import com.litongjava.tio.boot.exception.TioBootExceptionHandler;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.http.handler.controller.DynamicRequestController;
import com.litongjava.tio.boot.http.handler.controller.TioBootHttpControllerRouter;
import com.litongjava.tio.boot.http.handler.internal.AccessStatisticsHandler;
import com.litongjava.tio.boot.http.handler.internal.DefaultStaticResourceHandler;
import com.litongjava.tio.boot.http.handler.internal.HttpRequestFunctionHandler;
import com.litongjava.tio.boot.http.handler.internal.RequestStatisticsHandler;
import com.litongjava.tio.boot.http.handler.internal.ResponseStatisticsHandler;
import com.litongjava.tio.boot.http.handler.internal.StaticResourceHandler;
import com.litongjava.tio.boot.http.session.SessionLimit;
import com.litongjava.tio.boot.http.utils.TioHttpControllerUtils;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.watch.DirectoryWatcher;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.exception.TioHandlePacketException;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpMethod;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.http.common.session.HttpSession;
import com.litongjava.tio.http.server.handler.HttpRequestHandler;
import com.litongjava.tio.http.server.handler.RouteEntry;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import com.litongjava.tio.http.server.intf.HttpSessionListener;
import com.litongjava.tio.http.server.intf.ThrowableHandler;
import com.litongjava.tio.http.server.model.HttpCors;
import com.litongjava.tio.http.server.router.HttpRequestFunctionRouter;
import com.litongjava.tio.http.server.router.HttpRequestGroovyRouter;
import com.litongjava.tio.http.server.router.HttpRequestRouter;
import com.litongjava.tio.http.server.session.HttpSessionUtils;
import com.litongjava.tio.http.server.session.SessionCookieDecorator;
import com.litongjava.tio.http.server.stat.ip.path.IpPathAccessStats;
import com.litongjava.tio.http.server.stat.token.TokenPathAccessStats;
import com.litongjava.tio.http.server.util.CORSUtils;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.ArrayUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioBootHttpRequestDispatcher
implements ITioHttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(TioBootHttpRequestDispatcher.class);
    protected HttpConfig httpConfig;
    protected TioBootHttpControllerRouter httpControllerRouter = null;
    private HttpRequestRouter httpRequestRouter;
    private HttpRequestGroovyRouter httpGroovyRouter;
    private HttpRequestFunctionRouter httpRequestFunctionRouter;
    private HttpRequestInterceptor httpRequestInterceptor;
    private HttpRequestInterceptor httpRequestValidationInterceptor;
    private HttpSessionListener httpSessionListener;
    private ThrowableHandler throwableHandler;
    private SessionCookieDecorator sessionCookieDecorator;
    private IpPathAccessStats ipPathAccessStats;
    private TokenPathAccessStats tokenPathAccessStats;
    private RequestStatisticsHandler requestStatisticsHandler;
    private ResponseStatisticsHandler responseStatisticsHandler;
    private StaticResourceHandler staticResourceHandler;
    private HttpRequestHandler forwardHandler;
    private HttpRequestHandler notFoundHandler;
    private DynamicRequestController dynamicRequestController;
    private HttpRequestFunctionHandler httpRequestFunctionHandler;
    private AccessStatisticsHandler accessStatisticsHandler = new AccessStatisticsHandler();
    private boolean printReport = EnvUtils.getBoolean((String)"server.http.request.printReport", (boolean)false);
    private boolean corsEnable = EnvUtils.getBoolean((String)"server.http.response.cors.enable", (boolean)false);
    private boolean printUrl = EnvUtils.getBoolean((String)"server.http.request.printUrl", (boolean)false);
    private AbsCache sessionRateLimiterCache;
    private String contextPath;
    private int contextPathLength = 0;
    private String suffix;
    private int suffixLength = 0;
    private boolean compatibilityAssignment = true;

    public void init(HttpConfig httpConfig, CacheFactory cacheFactory, HttpRequestInterceptor defaultHttpRequestInterceptor, HttpRequestInterceptor httpRequestValidationInterceptor, HttpRequestRouter httpRequestRouter, HttpRequestGroovyRouter httpRequestGroovyRouter, HttpRequestFunctionRouter httpRequestFunctionRouter, TioBootHttpControllerRouter tioBootHttpControllerRoutes, HttpRequestHandler forwardHandler, HttpRequestHandler notFoundHandler, RequestStatisticsHandler requestStatisticsHandler, ResponseStatisticsHandler responseStatisticsHandler, StaticResourceHandler staticResourceHandler) {
        this.httpControllerRouter = tioBootHttpControllerRoutes;
        this.httpRequestInterceptor = defaultHttpRequestInterceptor;
        this.httpRequestValidationInterceptor = httpRequestValidationInterceptor;
        this.httpRequestRouter = httpRequestRouter;
        this.httpGroovyRouter = httpRequestGroovyRouter;
        this.forwardHandler = forwardHandler;
        this.notFoundHandler = notFoundHandler;
        this.requestStatisticsHandler = requestStatisticsHandler;
        this.responseStatisticsHandler = responseStatisticsHandler;
        this.httpRequestFunctionRouter = httpRequestFunctionRouter;
        if (httpConfig == null) {
            throw new RuntimeException("httpConfig cannot be null");
        }
        this.contextPath = httpConfig.getContextPath();
        this.suffix = httpConfig.getSuffix();
        if (StrUtil.isNotBlank((CharSequence)this.contextPath)) {
            this.contextPathLength = this.contextPath.length();
        }
        if (StrUtil.isNotBlank((CharSequence)this.suffix)) {
            this.suffixLength = this.suffix.length();
        }
        this.httpConfig = httpConfig;
        if (httpConfig.getMaxLiveTimeOfStaticRes() > 0) {
            long maxLiveTimeOfStaticRes = httpConfig.getMaxLiveTimeOfStaticRes();
            AbsCache staticResCache = cacheFactory.register("TIO_HTTP_STATIC_RES_CONTENT", Long.valueOf(maxLiveTimeOfStaticRes), null);
            StaticResourcesCache.setStaticResCache(staticResCache);
            StaticResourcesCache.setHttpConfig(httpConfig);
        }
        this.sessionRateLimiterCache = cacheFactory.register("TIO_HTTP_SESSION_RATE_LIMITER", Long.valueOf(60L), null);
        if (httpConfig.getPageRoot() != null) {
            try {
                this.monitorFileChanges();
            }
            catch (Exception e) {
                log.error("Error setting up file change monitor", (Throwable)e);
            }
        }
        this.staticResourceHandler = staticResourceHandler == null ? new DefaultStaticResourceHandler() : staticResourceHandler;
        this.dynamicRequestController = new DynamicRequestController();
        this.httpRequestFunctionHandler = new HttpRequestFunctionHandler();
    }

    public HttpSession createSession(HttpRequest request) {
        String sessionId = this.httpConfig.getSessionIdGenerator().sessionId(this.httpConfig, request);
        HttpSession httpSession = new HttpSession(sessionId);
        if (this.httpSessionListener != null) {
            this.httpSessionListener.doAfterCreated(request, httpSession, this.httpConfig);
        }
        return httpSession;
    }

    public HttpConfig getHttpConfig(HttpRequest request) {
        return this.httpConfig;
    }

    public HttpRequestInterceptor getHttpServerInterceptor() {
        return this.httpRequestInterceptor;
    }

    private boolean checkDomain(HttpRequest request) {
        Object[] allowDomains = this.httpConfig.getAllowDomains();
        if (allowDomains == null || allowDomains.length == 0) {
            return true;
        }
        String host = request.getHost();
        return ArrayUtil.contains((Object[])allowDomains, (Object)host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handler(HttpRequest request) throws Exception {
        HttpResponse httpResponse;
        request.setNeedForward(false);
        if (!this.checkDomain(request)) {
            String remark = "Incorrect domain name: " + request.getDomain();
            Tio.remove((ChannelContext)request.channelContext, (String)remark);
            HttpResponse httpResponse2 = new HttpResponse(request).body(remark);
            httpResponse2.setKeepConnection(false);
            return httpResponse2;
        }
        long startTime = SystemTimer.currTime;
        RequestLine requestLine = request.getRequestLine();
        String path = requestLine.path;
        if (StrUtil.isNotBlank((CharSequence)this.contextPath) && StrUtil.startWith((CharSequence)path, (CharSequence)this.contextPath)) {
            path = StrUtil.subSuf((CharSequence)path, (int)this.contextPathLength);
        }
        if (StrUtil.isNotBlank((CharSequence)this.suffix) && StrUtil.endWith((CharSequence)path, (CharSequence)this.suffix)) {
            path = StrUtil.sub((CharSequence)path, (int)0, (int)(path.length() - this.suffixLength));
        }
        requestLine.setPath(path);
        if (this.printUrl) {
            log.info("Accessed URL: {}", (Object)requestLine.toString());
        }
        if (HttpMethod.OPTIONS.equals((Object)requestLine.method)) {
            HttpResponse httpResponse3 = new HttpResponse(request);
            CORSUtils.enableCORS((HttpResponse)httpResponse3, (HttpCors)new HttpCors());
            return httpResponse3;
        }
        this.processCookieBeforeHandler(request, requestLine);
        if (this.httpConfig.isUseSession() && EnvUtils.getBoolean((String)"server.rate.limit.enable", (boolean)true) && (httpResponse = SessionLimit.check(request, path, this.httpConfig, this.sessionRateLimiterCache)) != null) {
            return httpResponse;
        }
        if (this.requestStatisticsHandler != null) {
            this.requestStatisticsHandler.count(request);
        }
        requestLine = request.getRequestLine();
        path = requestLine.path;
        httpResponse = new HttpResponse(request);
        try {
            Object method;
            RouteEntry functionEntry;
            TioRequestContext.hold(request, httpResponse);
            if (this.httpRequestValidationInterceptor != null && (httpResponse = this.httpRequestValidationInterceptor.doBeforeHandler(request, requestLine, httpResponse)) != null) {
                HttpResponse httpResponse4 = httpResponse;
                return httpResponse4;
            }
            if ((httpResponse = this.httpRequestInterceptor.doBeforeHandler(request, requestLine, httpResponse)) != null && this.printReport) {
                this.logInterceptorReport(requestLine, httpResponse);
            }
            HttpRequestHandler httpRequestHandler = null;
            if (httpResponse == null && (httpRequestHandler = this.httpRequestRouter.find(path)) != null) {
                if (this.printReport) {
                    this.logRouterReport(requestLine, httpRequestHandler, "httpRequestRouter");
                }
                httpResponse = httpRequestHandler.handle(request);
            }
            if (httpResponse == null && this.httpGroovyRouter != null && (httpRequestHandler = this.httpGroovyRouter.find(path)) != null) {
                if (this.printReport) {
                    this.logRouterReport(requestLine, httpRequestHandler, "httpGroovyRouter");
                }
                httpResponse = httpRequestHandler.handle(request);
            }
            if (httpResponse == null && this.httpRequestFunctionRouter != null && (functionEntry = this.httpRequestFunctionRouter.find(path)) != null) {
                if (this.printReport) {
                    this.logFunctionRouterReport(requestLine, (RouteEntry<Object, Object>)functionEntry);
                }
                httpResponse = this.httpRequestFunctionHandler.handleFunction(request, this.httpConfig, this.compatibilityAssignment, functionEntry, path);
            }
            if (httpResponse == null) {
                method = TioHttpControllerUtils.getActionMethod(request, requestLine, this.httpConfig, this.httpControllerRouter);
                if (method != null) {
                    if (this.printReport) {
                        this.logActionReport(requestLine, (Method)method);
                    }
                    httpResponse = this.dynamicRequestController.process(request, this.httpConfig, this.compatibilityAssignment, this.httpControllerRouter, (Method)method);
                } else {
                    if (this.forwardHandler != null) {
                        httpResponse = this.forwardHandler.handle(request);
                        if (httpResponse.getStatus().status == 404) {
                            httpResponse = null;
                        }
                    }
                    if (httpResponse == null && this.staticResourceHandler != null) {
                        httpResponse = this.staticResourceHandler.handle(path, request, this.httpConfig, StaticResourcesCache.getStaticResCache());
                    }
                    if (httpResponse == null) {
                        httpResponse = this.resp404(request, requestLine);
                    }
                }
            }
            if (this.corsEnable) {
                CORSUtils.enableCORS((HttpResponse)httpResponse);
            }
            method = httpResponse;
            return method;
        }
        catch (Throwable e) {
            try {
                httpResponse = this.resp500(request, requestLine, e);
                if (this.corsEnable) {
                    CORSUtils.enableCORS((HttpResponse)httpResponse);
                }
            }
            catch (Exception e1) {
                throw new TioHandlePacketException(e1);
            }
            HttpResponse httpResponse5 = httpResponse;
            return httpResponse5;
        }
        finally {
            Object userId = TioRequestContext.getUserId();
            TioRequestContext.release();
            long endTime = SystemTimer.currTime;
            long elapsedTime = endTime - startTime;
            try {
                this.processCookieAfterHandler(request, requestLine, httpResponse);
            }
            catch (Exception e) {
                log.error("Error processing cookies after handler for request: {}", (Object)requestLine, (Object)e);
            }
            if (this.httpRequestInterceptor != null) {
                try {
                    this.httpRequestInterceptor.doAfterHandler(request, requestLine, httpResponse, elapsedTime);
                }
                catch (Exception e) {
                    log.error("Error executing after handler interceptor for request: {}", (Object)requestLine, (Object)e);
                }
            }
            if (this.ipPathAccessStats != null) {
                this.accessStatisticsHandler.statIpPath(this.ipPathAccessStats, request, httpResponse, path, elapsedTime);
            }
            if (this.tokenPathAccessStats != null) {
                this.accessStatisticsHandler.statTokenPath(this.tokenPathAccessStats, request, httpResponse, path, elapsedTime);
            }
            if (request.isNeedForward()) {
                request.setForward(true);
                return this.handler(request);
            }
            if (this.responseStatisticsHandler != null) {
                try {
                    this.responseStatisticsHandler.count(request, requestLine, httpResponse, userId, elapsedTime);
                }
                catch (Exception e) {
                    log.error("Error counting response statistics for request: {}", (Object)requestLine, (Object)e);
                }
            }
        }
    }

    public void monitorFileChanges() {
        String pageRoot = this.httpConfig.getPageRoot();
        if (this.httpConfig.isMonitorFileChange() && pageRoot != null) {
            try {
                Path pageRootPath = Paths.get(pageRoot, new String[0]);
                if (Files.exists(pageRootPath, new LinkOption[0]) && Files.isDirectory(pageRootPath, new LinkOption[0])) {
                    DirectoryWatcher directoryWatcher = new DirectoryWatcher(pageRootPath);
                    directoryWatcher.start();
                    TioBootServer.me().setStaticResourcesDirectoryWatcher(directoryWatcher);
                    HookCan.me().addDestroyMethod(() -> {
                        DirectoryWatcher staticDirectoryWatcher = TioBootServer.me().getStaticResourcesDirectoryWatcher();
                        if (staticDirectoryWatcher != null) {
                            directoryWatcher.stop();
                        }
                    });
                    log.info("Started JDK WatchService monitor for directory: {}", (Object)pageRootPath);
                } else {
                    log.warn("No such directory: {}", (Object)pageRootPath);
                }
            }
            catch (IOException e) {
                log.error("Error setting up WatchService for pageRoot", (Throwable)e);
            }
        }
    }

    private void processCookieAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse httpResponse) {
        if (httpResponse == null || !this.httpConfig.isUseSession()) {
            return;
        }
        HttpSession httpSession = request.getHttpSession();
        String sessionId = HttpSessionUtils.getSessionId((HttpRequest)request);
        if (StrUtil.isBlank((String)sessionId)) {
            this.createSessionCookie(request, httpSession, httpResponse, false);
        } else {
            HttpSession httpSessionFromStore = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSessionFromStore == null) {
                this.createSessionCookie(request, httpSession, httpResponse, false);
            }
        }
    }

    private void createSessionCookie(HttpRequest request, HttpSession httpSession, HttpResponse httpResponse, boolean forceCreate) {
        Object existingCookie;
        if (httpResponse == null) {
            return;
        }
        if (!forceCreate && (existingCookie = request.channelContext.getAttribute("TIO_HTTP_SESSION_COOKIE")) != null) {
            return;
        }
        String sessionId = httpSession.getId();
        String domain = TioHttpControllerUtils.getDomain(request);
        String name = this.httpConfig.getSessionCookieName();
        long maxAge = Math.max(this.httpConfig.getSessionTimeout() * 30L, 315360000L);
        Cookie sessionCookie = new Cookie(domain, name, sessionId, Long.valueOf(maxAge));
        if (this.sessionCookieDecorator != null) {
            this.sessionCookieDecorator.decorate(sessionCookie, request, request.getDomain());
        }
        httpResponse.addCookie(sessionCookie);
        this.httpConfig.getSessionStore().put(sessionId, (Serializable)httpSession);
        request.channelContext.setAttribute("TIO_HTTP_SESSION_COOKIE", (Object)sessionCookie);
    }

    public HttpSession updateSessionId(HttpRequest request, HttpSession httpSession, HttpResponse httpResponse) {
        String oldId = httpSession.getId();
        String newId = this.httpConfig.getSessionIdGenerator().sessionId(this.httpConfig, request);
        httpSession.setId(newId);
        if (this.httpSessionListener != null) {
            this.httpSessionListener.doAfterCreated(request, httpSession, this.httpConfig);
        }
        this.httpConfig.getSessionStore().remove(oldId);
        this.createSessionCookie(request, httpSession, httpResponse, true);
        httpSession.update(this.httpConfig);
        return httpSession;
    }

    private void processCookieBeforeHandler(HttpRequest request, RequestLine requestLine) throws ExecutionException {
        if (!this.httpConfig.isUseSession()) {
            return;
        }
        String sessionId = HttpSessionUtils.getSessionId((HttpRequest)request);
        HttpSession httpSession = null;
        if (StrUtil.isBlank((String)sessionId)) {
            httpSession = this.createSession(request);
        } else {
            httpSession = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession == null) {
                if (log.isDebugEnabled()) {
                    log.info("Session ID '{}' has timed out for channel: {}", (Object)sessionId, (Object)request.channelContext);
                }
                httpSession = this.createSession(request);
            }
        }
        request.setHttpSession(httpSession);
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) throws Exception {
        Method method;
        String page404;
        if (this.notFoundHandler != null) {
            return this.notFoundHandler.handle(request);
        }
        if (this.httpControllerRouter != null && (page404 = this.httpConfig.getPage404()) != null && (method = this.httpControllerRouter.PATH_METHOD_MAP.get(page404)) != null) {
            return Resps.forward((HttpRequest)request, (String)page404);
        }
        HttpResponse httpResponse = TioRequestContext.getResponse();
        if (httpResponse != null) {
            return Resps.resp404((HttpResponse)httpResponse, (RequestLine)requestLine, (HttpConfig)this.httpConfig);
        }
        return Resps.resp404((HttpRequest)request, (RequestLine)requestLine, (HttpConfig)this.httpConfig);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) throws Exception {
        Object result;
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("Remote Address: ").append(request.getClientIp());
        sb.append("\r\n").append("Request: ").append(requestLine.toString());
        log.error(sb.toString(), throwable);
        if (this.throwableHandler != null) {
            return this.throwableHandler.handler(request, requestLine, throwable);
        }
        String page500 = this.httpConfig.getPage500();
        TioBootExceptionHandler exceptionHandler = TioBootServer.me().getExceptionHandler();
        if (page500 != null) {
            Method method;
            if (exceptionHandler != null) {
                exceptionHandler.handler(request, throwable);
            }
            if (this.httpControllerRouter != null && (method = this.httpControllerRouter.PATH_METHOD_MAP.get(page500)) != null) {
                return Resps.forward((HttpRequest)request, (String)page500);
            }
        } else if (exceptionHandler != null && (result = exceptionHandler.handler(request, throwable)) != null) {
            HttpResponse response = TioRequestContext.getResponse();
            return response.setJson(result);
        }
        return Resps.resp500((HttpRequest)request, (RequestLine)requestLine, (HttpConfig)this.httpConfig, (Throwable)throwable);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpServerInterceptor(HttpRequestInterceptor httpServerInterceptor) {
        this.httpRequestInterceptor = httpServerInterceptor;
    }

    public void clearStaticResCache() {
        AbsCache staticResCache = StaticResourcesCache.getStaticResCache();
        if (staticResCache != null) {
            staticResCache.clear();
        }
    }

    public HttpSessionListener getHttpSessionListener() {
        return this.httpSessionListener;
    }

    public void setHttpSessionListener(HttpSessionListener httpSessionListener) {
        this.httpSessionListener = httpSessionListener;
    }

    public SessionCookieDecorator getSessionCookieDecorator() {
        return this.sessionCookieDecorator;
    }

    public void setSessionCookieDecorator(SessionCookieDecorator sessionCookieDecorator) {
        this.sessionCookieDecorator = sessionCookieDecorator;
    }

    public IpPathAccessStats getIpPathAccessStats() {
        return this.ipPathAccessStats;
    }

    public void setIpPathAccessStats(IpPathAccessStats ipPathAccessStats) {
        this.ipPathAccessStats = ipPathAccessStats;
    }

    public ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    public TokenPathAccessStats getTokenPathAccessStats() {
        return this.tokenPathAccessStats;
    }

    public void setTokenPathAccessStats(TokenPathAccessStats tokenPathAccessStats) {
        this.tokenPathAccessStats = tokenPathAccessStats;
    }

    public boolean isCompatibilityAssignment() {
        return this.compatibilityAssignment;
    }

    public void setCompatibilityAssignment(boolean compatibilityAssignment) {
        this.compatibilityAssignment = compatibilityAssignment;
    }

    private void logInterceptorReport(RequestLine requestLine, HttpResponse httpResponse) {
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n-----------HTTP Request Interceptor Report---------------------\n");
            sb.append("Request: ").append(requestLine.toString()).append("\n").append("Interceptor: ").append(this.httpRequestInterceptor).append("\n").append("Response: ").append(httpResponse).append("\n\n");
            log.info(sb.toString());
        }
    }

    private void logRouterReport(RequestLine requestLine, HttpRequestHandler httpRequestHandler, String routerName) {
        if (this.printReport && log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n-----------").append(routerName).append(" Report---------------------\n");
            sb.append("Request: ").append(requestLine.toString()).append("\n").append("Handler: ").append(httpRequestHandler.toString()).append("\n");
            log.info(sb.toString());
        }
    }

    private void logFunctionRouterReport(RequestLine requestLine, RouteEntry<Object, Object> functionEntry) {
        if (this.printReport && log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n-----------HTTP Request Function Router Report---------------------\n");
            sb.append("Request: ").append(requestLine.toString()).append("\n").append("Function Entry: ").append(functionEntry.toString()).append("\n");
            log.info(sb.toString());
        }
    }

    private void logActionReport(RequestLine requestLine, Method method) {
        if (this.printReport && log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n-----------Action Report---------------------\n");
            sb.append("Request: ").append(requestLine.toString()).append("\n").append("Method: ").append(method.toString()).append("\n");
            log.info(sb.toString());
        }
    }
}

