/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.internal;

import com.litongjava.annotation.EnableCORS;
import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.boot.http.utils.TioActionResponseProcessor;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.handler.IHttpRequestFunction;
import com.litongjava.tio.http.server.handler.RouteEntry;
import com.litongjava.tio.http.server.model.HttpCors;
import com.litongjava.tio.http.server.util.CORSUtils;
import com.litongjava.tio.utils.json.JsonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class HttpRequestFunctionHandler {
    public <T> HttpResponse handleFunction(HttpRequest request, HttpConfig httpConfig, boolean compatibilityAssignment, RouteEntry<?, ?> routeEntry, String path) {
        Object result;
        IHttpRequestFunction function;
        block20: {
            if (routeEntry == null) {
                throw new RuntimeException("No route found for path: " + path);
            }
            function = routeEntry.getFunction();
            TioTypeReference typeReference = routeEntry.getTypeReference();
            Type type = typeReference.getType();
            result = null;
            try {
                byte[] body;
                if (type == byte[].class) {
                    body = request.getBody();
                    result = function.handle((Object)body);
                    break block20;
                }
                if (type == String.class) {
                    String bodyString = request.getBodyString();
                    result = function.handle((Object)bodyString);
                    break block20;
                }
                if (type == Integer.class) {
                    Integer bodyInt = Integer.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyInt);
                    break block20;
                }
                if (type == Long.class) {
                    Long bodyLong = Long.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyLong);
                    break block20;
                }
                if (type == Double.class) {
                    Double bodyDouble = Double.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyDouble);
                    break block20;
                }
                if (type == Float.class) {
                    Float bodyFloat = Float.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyFloat);
                    break block20;
                }
                if (type == Boolean.class) {
                    Boolean bodyBoolean = Boolean.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyBoolean);
                    break block20;
                }
                if (type == Byte.class) {
                    Byte bodyByte = Byte.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyByte);
                    break block20;
                }
                if (type == Short.class) {
                    Short bodyShort = Short.valueOf(request.getBodyString());
                    result = function.handle((Object)bodyShort);
                    break block20;
                }
                if (type == Character.class) {
                    Character bodyChar = Character.valueOf(request.getBodyString().charAt(0));
                    result = function.handle((Object)bodyChar);
                    break block20;
                }
                body = request.getBody();
                Object functionInput = JsonUtils.parse((byte[])body, (Type)type);
                try {
                    result = function.handle(functionInput);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Error casting parsed object to the required type: " + type, e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing request", e);
            }
        }
        HttpResponse response = TioActionResponseProcessor.afterExecuteAction(result);
        boolean isEnableCORS = false;
        EnableCORS enableCORS = null;
        try {
            Class<?> clazz;
            Method actionMethod = function.getClass().getDeclaredMethod("handle", Object.class);
            enableCORS = actionMethod.getAnnotation(EnableCORS.class);
            if (enableCORS != null) {
                isEnableCORS = true;
            }
            if (!isEnableCORS && (enableCORS = (clazz = function.getClass()).getAnnotation(EnableCORS.class)) != null) {
                isEnableCORS = true;
            }
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Error accessing method handle in IHttpRequestFunction", ex);
        }
        if (isEnableCORS) {
            CORSUtils.enableCORS((HttpResponse)response, (HttpCors)new HttpCors(enableCORS));
        }
        return response;
    }
}

