/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.internal;

import com.litongjava.tio.boot.http.handler.internal.StaticResourceHandler;
import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResource;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.view.freemarker.FreemarkerConfig;
import com.litongjava.tio.http.server.handler.FileCache;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.freemarker.FreemarkerUtils;
import com.litongjava.tio.utils.hutool.ArrayUtil;
import com.litongjava.tio.utils.hutool.FileUtil;
import com.litongjava.tio.utils.url.UrlUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStaticResourceHandler
implements StaticResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultStaticResourceHandler.class);
    private static final long MAX_CACHE_FILE_SIZE = 0x500000L;

    @Override
    public HttpResponse handle(String path, HttpRequest request, HttpConfig httpConfig, AbsCache staticResCache) {
        path = UrlUtils.decode((String)path);
        boolean enable = EnvUtils.getBoolean((String)"server.resources.static.file.cache.enable", (boolean)false);
        HttpResponse response = null;
        FileCache fileCache = null;
        if (enable && staticResCache != null) {
            fileCache = (FileCache)staticResCache.get(path);
        }
        if (enable && fileCache != null) {
            long lastModified = fileCache.getLastModified();
            response = Resps.try304((HttpRequest)request, (long)lastModified);
            if (response != null) {
                response.addHeader(HeaderName.tio_from_cache, HeaderValue.Tio_From_Cache.TRUE);
                return response;
            }
            response = new HttpResponse(request);
            response.setBody(fileCache.getContent());
            response.setLastModified(HeaderValue.from((String)String.valueOf(lastModified)));
            response.setSkipGzipped(fileCache.isHasGzipped());
            if (fileCache.getContentType() != null) {
                response.addHeader(HeaderName.Content_Type, fileCache.getContentType());
            }
            if (fileCache.getContentEncoding() != null) {
                response.addHeader(HeaderName.Content_Encoding, fileCache.getContentEncoding());
            }
            return response;
        }
        String pageRoot = httpConfig.getPageRoot(request);
        if (pageRoot != null) {
            HttpResource httpResource;
            try {
                httpResource = httpConfig.getResource(request, path);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (httpResource != null) {
                response = this.readFile(request, httpConfig, httpResource, staticResCache, enable);
                return response;
            }
        }
        return response;
    }

    private HttpResponse readFile(HttpRequest request, HttpConfig httpConfig, HttpResource httpResource, AbsCache staticResCache, boolean cacheFile) {
        Configuration configuration;
        HttpResponse response = null;
        String path = httpResource.getPath();
        File file = httpResource.getFile();
        String template = httpResource.getPath();
        String extension = FileUtil.extName((String)template);
        FreemarkerConfig freemarkerConfig = httpConfig.getFreemarkerConfig();
        if (freemarkerConfig != null && ArrayUtil.contains((Object[])freemarkerConfig.getSuffixes(), (Object)extension) && (configuration = freemarkerConfig.getConfiguration(request)) != null) {
            Object model = null;
            try {
                model = freemarkerConfig.getModelGenerator().generate(request);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
            if (request.isClosed()) {
                return null;
            }
            if (model instanceof HttpResponse) {
                response = (HttpResponse)model;
                return response;
            }
            try {
                String retStr = FreemarkerUtils.generateStringByPath((String)template, (Configuration)configuration, (Object)model);
                response = Resps.bytes((HttpRequest)request, (byte[])retStr.getBytes(configuration.getDefaultEncoding()), (String)extension);
                return response;
            }
            catch (Throwable e) {
                try {
                    log.error("Freemarker error, treated as ordinary text processing\uff1a" + file.getCanonicalPath() + ", " + e.toString());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        byte[] content = null;
        HeaderValue lastModified = null;
        long fileLastModified = 0L;
        if (file != null) {
            fileLastModified = file.lastModified();
            content = FileUtil.readBytes((File)file);
            lastModified = HeaderValue.from((String)String.valueOf(fileLastModified));
        } else {
            URL url = httpResource.getUrl();
            if (url == null) {
                return null;
            }
            fileLastModified = ManagementFactory.getRuntimeMXBean().getStartTime();
            lastModified = HeaderValue.from((String)String.valueOf(fileLastModified));
            try {
                content = FileUtil.readBytes((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        response = Resps.bytes((HttpRequest)request, (byte[])content, (String)extension);
        response.setStaticRes(true);
        response.setLastModified(lastModified);
        if (cacheFile && response.isStaticRes() && staticResCache != null && response.getBody() != null && response.getStatus() == HttpResponseStatus.C200) {
            if ((long)content.length <= 0x500000L) {
                HeaderValue contentType = response.getHeader(HeaderName.Content_Type);
                HeaderValue contentEncoding = response.getHeader(HeaderName.Content_Encoding);
                FileCache newFileCache = new FileCache(content, fileLastModified, contentType, contentEncoding, response.isSkipGzipped());
                staticResCache.put(path, (Serializable)newFileCache);
                if (log.isInfoEnabled()) {
                    log.info("add to cache:[{}], {}(B)", (Object)path, (Object)content.length);
                }
            } else {
                log.info("File size exceeds cache limit, not cached: [{}], {}(B)", (Object)path, (Object)content.length);
            }
        }
        return response;
    }
}

