/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.internal;

import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.intf.CurrUseridGetter;
import com.litongjava.tio.http.server.session.HttpSessionUtils;
import com.litongjava.tio.http.server.stat.StatPathFilter;
import com.litongjava.tio.http.server.stat.ip.path.IpAccessStat;
import com.litongjava.tio.http.server.stat.ip.path.IpPathAccessStat;
import com.litongjava.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import com.litongjava.tio.http.server.stat.ip.path.IpPathAccessStats;
import com.litongjava.tio.http.server.stat.token.TokenAccessStat;
import com.litongjava.tio.http.server.stat.token.TokenPathAccessStat;
import com.litongjava.tio.http.server.stat.token.TokenPathAccessStatListener;
import com.litongjava.tio.http.server.stat.token.TokenPathAccessStats;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.List;

public class AccessStatisticsHandler {
    public boolean statIpPath(IpPathAccessStats ipPathAccessStats, HttpRequest request, HttpResponse response, String path, long iv) {
        if (response == null) {
            return false;
        }
        if (response.isSkipIpStat() || request.isClosed()) {
            return true;
        }
        String ip = request.getClientIp();
        String sessionId = HttpSessionUtils.getSessionId((HttpRequest)request);
        StatPathFilter statPathFilter = ipPathAccessStats.getStatPathFilter();
        for (Long duration : ipPathAccessStats.durationList) {
            boolean isContinue;
            IpPathAccessStatListener ipPathAccessStatListener;
            IpAccessStat ipAccessStat = ipPathAccessStats.get(duration, ip);
            ipAccessStat.count.incrementAndGet();
            ipAccessStat.timeCost.addAndGet(iv);
            ipAccessStat.setLastAccessTime(SystemTimer.currTime);
            if (StrUtil.isBlank((String)sessionId)) {
                ipAccessStat.noSessionCount.incrementAndGet();
            } else {
                ipAccessStat.sessionIds.add((Object)sessionId);
            }
            if (!statPathFilter.filter(path, request, response)) continue;
            IpPathAccessStat ipPathAccessStat = ipAccessStat.get(path);
            ipPathAccessStat.count.incrementAndGet();
            ipPathAccessStat.timeCost.addAndGet(iv);
            ipPathAccessStat.setLastAccessTime(SystemTimer.currTime);
            if (StrUtil.isBlank((String)sessionId)) {
                ipPathAccessStat.noSessionCount.incrementAndGet();
            }
            if ((ipPathAccessStatListener = ipPathAccessStats.getListener(duration)) == null || (isContinue = ipPathAccessStatListener.onChanged(request, ip, path, ipAccessStat, ipPathAccessStat))) continue;
            return false;
        }
        return true;
    }

    public boolean statTokenPath(TokenPathAccessStats tokenPathAccessStats, HttpRequest request, HttpResponse response, String path, long iv) {
        if (response == null) {
            return false;
        }
        if (response.isSkipTokenStat() || request.isClosed()) {
            return true;
        }
        String token = tokenPathAccessStats.getTokenGetter().getToken(request);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            List list = tokenPathAccessStats.durationList;
            CurrUseridGetter currUseridGetter = tokenPathAccessStats.getCurrUseridGetter();
            String uid = null;
            if (currUseridGetter != null) {
                uid = currUseridGetter.getUserid(request);
            }
            StatPathFilter statPathFilter = tokenPathAccessStats.getStatPathFilter();
            for (Long duration : list) {
                boolean isContinue;
                TokenAccessStat tokenAccessStat = tokenPathAccessStats.get(duration, token, request.getClientIp(), uid);
                tokenAccessStat.count.incrementAndGet();
                tokenAccessStat.timeCost.addAndGet(iv);
                tokenAccessStat.setLastAccessTime(SystemTimer.currTime);
                if (!statPathFilter.filter(path, request, response)) continue;
                TokenPathAccessStat tokenPathAccessStat = tokenAccessStat.get(path);
                tokenPathAccessStat.count.incrementAndGet();
                tokenPathAccessStat.timeCost.addAndGet(iv);
                tokenPathAccessStat.setLastAccessTime(SystemTimer.currTime);
                TokenPathAccessStatListener tokenPathAccessStatListener = tokenPathAccessStats.getListener(duration);
                if (tokenPathAccessStatListener == null || (isContinue = tokenPathAccessStatListener.onChanged(request, token, path, tokenAccessStat, tokenPathAccessStat))) continue;
                return false;
            }
        }
        return true;
    }
}

