/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.druid;

import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.util.PatternMatcher;
import com.alibaba.druid.util.ServletPathMatcher;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DruidWebStatInterceptor
implements HttpRequestInterceptor {
    private final PatternMatcher pathMatcher = new ServletPathMatcher();
    private final Set<String> excludes;
    private final boolean profileEnable;
    private final WebAppStat webAppStat;

    public DruidWebStatInterceptor(String contextPath, String exclusionsCsv, boolean profileEnable) {
        this.excludes = new HashSet<String>(Arrays.asList(exclusionsCsv.split("\\s*,\\s*")));
        this.profileEnable = profileEnable;
        this.webAppStat = new WebAppStat(contextPath, 0);
        WebAppStatManager.getInstance().addWebAppStatSet((Object)this.webAppStat);
    }

    private boolean isExclusion(String uri) {
        if (uri == null) {
            return false;
        }
        for (String pattern : this.excludes) {
            if (!this.pathMatcher.matches(pattern, uri)) continue;
            return true;
        }
        return false;
    }

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine line, HttpResponse originalResponse) throws Exception {
        String uri = line.getPath();
        if (this.isExclusion(uri)) {
            return null;
        }
        long startNano = System.nanoTime();
        long startMillis = System.currentTimeMillis();
        WebRequestStat wrs = new WebRequestStat(startNano, startMillis);
        WebRequestStat.set((WebRequestStat)wrs);
        this.webAppStat.beforeInvoke();
        WebURIStat uriStat = this.webAppStat.getURIStat(uri, false);
        if (uriStat != null) {
            uriStat.beforeInvoke();
        }
        if (this.profileEnable) {
            Profiler.initLocal();
            Profiler.enter((String)uri, (String)"WEB");
        }
        request.setLocalAttribute("_druid_startNano", (Object)startNano);
        request.setLocalAttribute("_druid_uriStat", (Object)uriStat);
        return null;
    }

    public void doAfterHandler(HttpRequest request, RequestLine line, HttpResponse response, long costMillis) throws Exception {
        String uri = line.getPath();
        if (this.isExclusion(uri)) {
            return;
        }
        Long startNano = (Long)request.getLocalAttribute("_druid_startNano");
        if (startNano == null) {
            return;
        }
        long endNano = System.nanoTime();
        long nanos = endNano - startNano;
        WebRequestStat wrs = WebRequestStat.current();
        wrs.setEndNano(endNano);
        this.webAppStat.afterInvoke(null, nanos);
        WebURIStat uriStat = (WebURIStat)request.getLocalAttribute("_druid_uriStat");
        if (uriStat == null && (uriStat = this.webAppStat.getURIStat(uri, true)) != null) {
            uriStat.beforeInvoke();
        }
        if (uriStat != null) {
            uriStat.afterInvoke(null, nanos);
            if (this.profileEnable) {
                Profiler.release((long)nanos);
                Map stats = Profiler.getStatsMap();
                uriStat.getProfiletat().record(stats);
                Profiler.removeLocal();
            }
        }
        WebRequestStat.set(null);
    }
}

