/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.druid;

import com.alibaba.druid.stat.DruidStatService;
import com.alibaba.druid.support.http.util.IPAddress;
import com.alibaba.druid.support.http.util.IPRange;
import com.alibaba.druid.util.Utils;
import com.litongjava.tio.boot.druid.DruidConfig;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.session.SessionStroe;
import com.litongjava.tio.http.common.utils.HttpIpUtils;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DruidStatHandler {
    private static final String PREFIX = "/druid";
    private static final String COOKIE_NAME = "DRUID-SESSION";
    private final DruidStatService statService = DruidStatService.getInstance();
    private final String resourcePath = "support/http/resources";
    private String jmxUrl;
    private String jmxUsername;
    private String jmxPassword;
    private MBeanServerConnection conn;
    private String loginUser;
    private String loginPass;
    private boolean resetEnable;
    private final List<IPRange> allowList = new ArrayList<IPRange>();
    private final List<IPRange> denyList = new ArrayList<IPRange>();
    private final boolean removeAdvertise;

    public DruidStatHandler(DruidConfig config) {
        this.loginUser = config.getLoginUsername();
        this.loginPass = config.getLoginPassword();
        this.resetEnable = config.isResetEnable();
        this.jmxUrl = config.getJmxUrl();
        this.jmxUsername = config.getJmxUsername();
        this.jmxPassword = config.getJmxPassword();
        config.getAllowIps().forEach(ip -> this.allowList.add(new IPRange(ip)));
        config.getDenyIps().forEach(ip -> this.denyList.add(new IPRange(ip)));
        this.statService.setResetEnable(this.resetEnable);
        if (this.jmxUrl != null && !this.jmxUrl.isEmpty()) {
            try {
                this.initJmxConn();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.removeAdvertise = config.isRemoveAdvertise();
    }

    public HttpResponse handle(HttpRequest request) throws Exception {
        String fullPath = request.getRequestLine().getPath();
        if (!fullPath.startsWith(PREFIX)) {
            return null;
        }
        HttpResponse response = TioRequestContext.getResponse();
        String subPath = fullPath.substring(PREFIX.length());
        String remote = HttpIpUtils.getRealIp((HttpRequest)request);
        if (!this.isPermitted(remote)) {
            return this.serveResource("/nopermit.html", response);
        }
        if ("/submitLogin".equals(subPath)) {
            String u = request.getParameter("loginUsername");
            String p = request.getParameter("loginPassword");
            if (this.loginUser.equals(u) && this.loginPass.equals(p)) {
                String sessionId = UUID.randomUUID().toString();
                SessionStroe.putString((String)sessionId, (String)u);
                response.setHeader("Set-Cookie", "DRUID-SESSION=" + sessionId + "; Path=/druid; HttpOnly; Max-Age=86400");
                response.body("success");
                return response;
            }
            response.body("error");
            return response;
        }
        boolean loggedIn = false;
        String cookie = request.getHeader("cookie");
        if (cookie != null) {
            for (String token : cookie.split(";")) {
                if (!(token = token.trim()).startsWith("DRUID-SESSION=")) continue;
                String sessionId = token.substring("DRUID-SESSION=".length());
                if (!SessionStroe.containsKey((String)sessionId)) break;
                loggedIn = true;
                break;
            }
        }
        if (!(this.loginUser == null || loggedIn || subPath.equals("/login.html") || subPath.startsWith("/css") || subPath.startsWith("/js") || subPath.startsWith("/img"))) {
            response.sendRedirect("/druid/login.html");
            return response;
        }
        if (subPath.endsWith(".json")) {
            String queryString = request.getRequestLine().getQueryString();
            String url = subPath + (StrUtil.isNotBlank((CharSequence)queryString) ? "?" + queryString : "");
            String result = this.process(url);
            response.setString(result, "utf-8", "application/json; charset=utf-8");
            return response;
        }
        return this.serveResource(subPath, response);
    }

    private HttpResponse serveResource(String path, HttpResponse response) throws IOException {
        if (path.equals("") || "/".equals(path)) {
            response.sendRedirect("/druid/index.html");
            return response;
        }
        String file = "support/http/resources" + path;
        if (this.removeAdvertise && file.endsWith("js/common.js")) {
            String js = Utils.readFromResource((String)file);
            js = js.replaceAll("<a.*?banner\".*?</a><br/>", "");
            js = js.replaceAll("powered.*?shrek\\.wang</a>", "");
            response.setString(js, "utf-8", "application/javascript; charset=utf-8");
            return response;
        }
        if (file.endsWith(".css")) {
            String txt = Utils.readFromResource((String)file);
            response.setString(txt, "utf-8", "text/css; charset=utf-8");
            return response;
        }
        if (file.endsWith(".js")) {
            String txt = Utils.readFromResource((String)file);
            response.setString(txt, "utf-8", "application/javascript; charset=utf-8");
            return response;
        }
        if (file.endsWith(".html")) {
            String txt = Utils.readFromResource((String)file);
            response.setString(txt, "utf-8", "text/html; charset=utf-8");
            return response;
        }
        if (file.endsWith(".jpg") || file.endsWith(".png")) {
            byte[] data = Utils.readByteArrayFromResource((String)file);
            return Resps.bytesWithContentType((HttpResponse)response, (byte[])data, (String)(file.endsWith(".png") ? "image/png" : "image/jpeg"));
        }
        byte[] data = Utils.readByteArrayFromResource((String)file);
        return Resps.bytesWithContentType((HttpResponse)response, (byte[])data, (String)"application/octet-stream");
    }

    private String process(String url) {
        try {
            if (this.jmxUrl == null) {
                return this.statService.service(url);
            }
            if (this.conn == null) {
                this.initJmxConn();
            }
            return this.getJmxResult(this.conn, url);
        }
        catch (Exception e) {
            return DruidStatService.returnJSONResult((int)-1, (Object)e.getMessage());
        }
    }

    private void initJmxConn() throws IOException {
        JMXServiceURL u = new JMXServiceURL(this.jmxUrl);
        Map<String, String[]> env = null;
        if (this.jmxUsername != null) {
            String[] creds = new String[]{this.jmxUsername, this.jmxPassword};
            env = Collections.singletonMap("jmx.remote.credentials", creds);
        }
        JMXConnector jmxc = JMXConnectorFactory.connect(u, env);
        this.conn = jmxc.getMBeanServerConnection();
    }

    private String getJmxResult(MBeanServerConnection c, String url) throws Exception {
        ObjectName name = new ObjectName("com.alibaba.druid:type=DruidStatService");
        return (String)c.invoke(name, "service", new Object[]{url}, new String[]{String.class.getName()});
    }

    private boolean isPermitted(String ip) {
        if (ip.contains(":")) {
            return "0:0:0:0:0:0:0:1".equals(ip) || this.denyList.isEmpty() && this.allowList.isEmpty();
        }
        IPAddress addr = new IPAddress(ip);
        for (IPRange r : this.denyList) {
            if (!r.isIPAddressInRange(addr)) continue;
            return false;
        }
        if (!this.allowList.isEmpty()) {
            for (IPRange r : this.allowList) {
                if (!r.isIPAddressInRange(addr)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

