/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.proxy;

import com.jfinal.kit.Kv;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import com.litongjava.jfinal.aop.AopBefore;
import com.litongjava.jfinal.aop.AopClear;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.InterceptorManager;
import com.litongjava.jfinal.proxy.ProxyClass;
import com.litongjava.jfinal.proxy.ProxyClassTemplate;
import com.litongjava.jfinal.proxy.ProxyMethod;
import com.litongjava.jfinal.proxy.ProxyMethodCache;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyGenerator {
    private static final Logger log = LoggerFactory.getLogger(ProxyGenerator.class);
    protected Engine engine = null;
    protected Template template = null;
    protected boolean printGeneratedClassToConsole = false;
    protected boolean printGeneratedClassToLog = true;

    public ProxyGenerator() {
        String filename = "com/litongjava/jfinal/proxy/proxy_class_template.jf";
        this.engine = new Engine("forProxy").setToClassPathSourceFactory();
        String baseTemplatePath = this.engine.getEngineConfig().getBaseTemplatePath();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String finalFileName = this.buildFinalFileName(baseTemplatePath, filename);
        URL url = classLoader.getResource(finalFileName);
        if (url != null) {
            this.template = this.engine.getTemplate(filename);
        } else {
            this.engine = new Engine("forProxy").setSourceFactory((ISourceFactory)new FileSourceFactory());
            new ProxyClassTemplate("proxy_class_template.jf").create();
            this.template = this.engine.getTemplate("proxy_class_template.jf");
        }
    }

    public String buildFinalFileName(String baseTemplatePath, String fileName) {
        char firstChar;
        String finalFileName = baseTemplatePath != null ? ((firstChar = fileName.charAt(0)) == '/' || firstChar == '\\' ? baseTemplatePath + fileName : baseTemplatePath + "/" + fileName) : fileName;
        if (finalFileName.charAt(0) == '/') {
            finalFileName = finalFileName.substring(1);
        }
        return finalFileName;
    }

    public ProxyClass generate(Class<?> target) {
        Method[] methodArray;
        ProxyClass proxyClass = new ProxyClass(target);
        Kv clazz = Kv.create();
        clazz.set((Object)"pkg", (Object)proxyClass.getPkg());
        clazz.set((Object)"name", (Object)proxyClass.getName());
        clazz.set((Object)"targetName", (Object)this.getTargetName(target));
        TypeVariable[] tvs = target.getTypeParameters();
        clazz.set((Object)"classTypeVars", (Object)this.getTypeVars(tvs));
        clazz.set((Object)"targetTypeVars", (Object)this.getTargetTypeVars(tvs));
        List<Class<?>> methodUpperInters = this.getMethodUpperInterceptors(proxyClass);
        ArrayList<Kv> methodList = new ArrayList<Kv>();
        clazz.set((Object)"methodList", methodList);
        for (Method m : methodArray = target.getMethods()) {
            if (this.isSkipMethod(m) || !this.hasInterceptor(methodUpperInters, proxyClass, m)) continue;
            Kv method = Kv.create();
            method.set((Object)"methodTypeVars", (Object)this.getTypeVars(m.getTypeParameters()));
            method.set((Object)"returnType", (Object)this.getReturnType(m));
            method.set((Object)"name", (Object)m.getName());
            method.set((Object)"throws", (Object)this.getThrows(m));
            Parameter[] paras = m.getParameters();
            List paraTypes = Arrays.asList(paras).stream().map(x -> {
                StringBuilder sb = new StringBuilder();
                Type type = x.getParameterizedType();
                String typename = type.getTypeName();
                if (x.isVarArgs()) {
                    sb.append(typename.replaceFirst("\\[\\]$", "..."));
                } else {
                    sb.append(typename);
                }
                return sb.toString();
            }).collect(Collectors.toList());
            method.set((Object)"paraTypes", paraTypes);
            Long proxyMethodKey = ProxyMethodCache.generateKey();
            method.set((Object)"proxyMethodKey", (Object)proxyMethodKey);
            if (paras.length == 1 && (paras[0].getType().isArray() || paras[0].isVarArgs())) {
                method.set((Object)"singleArrayPara", (Object)true);
            }
            if (m.getReturnType() != Void.TYPE) {
                method.set((Object)"frontReturn", (Object)"return ");
            } else {
                method.set((Object)"backReturn", (Object)"return null;");
            }
            methodList.add(method);
            ProxyMethod proxyMethod = new ProxyMethod();
            proxyClass.addProxyMethod(proxyMethod);
            proxyMethod.setKey(proxyMethodKey);
            proxyMethod.setTargetClass(target);
            proxyMethod.setMethod(m);
        }
        if (proxyClass.needProxy()) {
            String sourceCode = this.template.renderToString((Map)clazz);
            proxyClass.setSourceCode(sourceCode);
            if (this.printGeneratedClassToConsole) {
                String msg = "Generate proxy class \"" + proxyClass.getPkg() + "." + proxyClass.getName() + "\":";
                System.out.print(msg);
                System.out.println(sourceCode);
            }
            if (this.printGeneratedClassToLog && log.isDebugEnabled()) {
                String msg = "\nGenerate proxy class \"" + proxyClass.getPkg() + "." + proxyClass.getName() + "\":";
                log.debug(msg + sourceCode);
            }
        }
        return proxyClass;
    }

    protected String getTargetName(Class<?> target) {
        if (Modifier.isStatic(target.getModifiers())) {
            String ret = target.getName();
            int index = ret.lastIndexOf(36);
            return ret.substring(0, index) + "." + ret.substring(index + 1);
        }
        return target.getSimpleName();
    }

    protected String getReturnType(Method method) {
        return method.getGenericReturnType().getTypeName();
    }

    protected String getTypeVars(TypeVariable[] typeVars) {
        if (typeVars == null || typeVars.length == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        ret.append('<');
        for (int i = 0; i < typeVars.length; ++i) {
            TypeVariable tv = typeVars[i];
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(tv.getName());
            Type[] bounds = tv.getBounds();
            if (bounds.length == 1) {
                if (bounds[0] == Object.class) continue;
                ret.append(" extends ").append(bounds[0].getTypeName());
                continue;
            }
            for (int j = 0; j < bounds.length; ++j) {
                String tn = bounds[j].getTypeName();
                if (j > 0) {
                    ret.append(" & ").append(tn);
                    continue;
                }
                ret.append(" extends ").append(tn);
            }
        }
        return ret.append('>').toString();
    }

    protected String getTargetTypeVars(TypeVariable[] typeVars) {
        if (typeVars == null || typeVars.length == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        ret.append('<');
        for (int i = 0; i < typeVars.length; ++i) {
            TypeVariable tv = typeVars[i];
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(tv.getName());
        }
        return ret.append('>').toString();
    }

    protected String getThrows(Method method) {
        Class<?>[] throwTypes = method.getExceptionTypes();
        if (throwTypes == null || throwTypes.length == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder().append("throws ");
        for (int i = 0; i < throwTypes.length; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(throwTypes[i].getName());
        }
        return ret.append(' ').toString();
    }

    protected boolean isSkipMethod(Method method) {
        int mod = method.getModifiers();
        if (!Modifier.isPublic(mod)) {
            return true;
        }
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || Modifier.isAbstract(mod)) {
            return true;
        }
        String n = method.getName();
        return n.equals("toString") || n.equals("hashCode") || n.equals("equals");
    }

    protected List<Class<?>> getMethodUpperInterceptors(ProxyClass proxyClass) {
        List<Class<?>> ret;
        AopClear clearOnClass = proxyClass.getTarget().getAnnotation(AopClear.class);
        if (clearOnClass != null) {
            Class<? extends AopInterceptor>[] clearIntersOnClass = clearOnClass.value();
            if (clearIntersOnClass.length != 0) {
                ret = InterceptorManager.me().getGlobalServiceInterceptorClasses();
                this.removeInterceptor(ret, clearIntersOnClass);
            } else {
                ret = new ArrayList(3);
            }
        } else {
            ret = InterceptorManager.me().getGlobalServiceInterceptorClasses();
        }
        AopBefore beforeOnClass = proxyClass.getTarget().getAnnotation(AopBefore.class);
        if (beforeOnClass != null) {
            Class<? extends AopInterceptor>[] classInters;
            for (Class<? extends AopInterceptor> c : classInters = beforeOnClass.value()) {
                ret.add(c);
            }
        }
        return ret;
    }

    protected void removeInterceptor(List<Class<?>> target, Class<?>[] clearInters) {
        if (target.isEmpty() || clearInters.length == 0) {
            return;
        }
        Iterator<Class<?>> it = target.iterator();
        block0: while (it.hasNext()) {
            Class<?> interClass = it.next();
            for (Class<?> c : clearInters) {
                if (c != interClass) continue;
                it.remove();
                continue block0;
            }
        }
    }

    protected boolean hasInterceptor(List<Class<?>> methodUpperInters, ProxyClass proxyClass, Method method) {
        List<Class<?>> ret;
        AopBefore beforeOnMethod = method.getAnnotation(AopBefore.class);
        if (beforeOnMethod != null && beforeOnMethod.value().length != 0) {
            return true;
        }
        AopClear clearOnMethod = method.getAnnotation(AopClear.class);
        if (clearOnMethod != null) {
            Class<? extends AopInterceptor>[] clearIntersOnMethod = clearOnMethod.value();
            if (clearIntersOnMethod.length != 0) {
                ret = this.copyInterceptors(methodUpperInters);
                this.removeInterceptor(ret, clearIntersOnMethod);
            } else {
                ret = null;
            }
        } else {
            ret = methodUpperInters;
        }
        return ret != null && ret.size() > 0;
    }

    protected List<Class<?>> copyInterceptors(List<Class<?>> methodUpperInters) {
        ArrayList ret = new ArrayList(methodUpperInters.size());
        for (Class<?> c : methodUpperInters) {
            ret.add(c);
        }
        return ret;
    }

    public void setPrintGeneratedClassToConsole(boolean printGeneratedClassToConsole) {
        this.printGeneratedClassToConsole = printGeneratedClassToConsole;
    }

    public void setPrintGeneratedClassToLog(boolean printGeneratedClassToLog) {
        this.printGeneratedClassToLog = printGeneratedClassToLog;
    }
}

