/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.proxy;

import com.litongjava.jfinal.aop.AopManager;
import com.litongjava.jfinal.dubbo.Dubbo;
import com.litongjava.jfinal.proxy.ProxyClass;
import com.litongjava.jfinal.proxy.ProxyClassLoader;
import com.litongjava.jfinal.proxy.ProxyCompiler;
import com.litongjava.jfinal.proxy.ProxyGenerator;
import com.litongjava.jfinal.proxy.ProxyMethod;
import com.litongjava.jfinal.proxy.ProxyMethodCache;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyFactory {
    protected ConcurrentHashMap<Class<?>, Class<?>> cache = new ConcurrentHashMap();
    protected ProxyGenerator proxyGenerator = new ProxyGenerator();
    protected ProxyCompiler proxyCompiler = new ProxyCompiler();
    protected ProxyClassLoader proxyClassLoader = new ProxyClassLoader();
    private Boolean enableDubbo = AopManager.me().getEnableDubbo();

    public <T> T get(Class<T> target) {
        try {
            Class<?> ret = this.cache.get(target);
            if (ret != null) {
                return (T)ret.newInstance();
            }
            int mod = target.getModifiers();
            if (!Modifier.isPublic(mod)) {
                throw new IllegalArgumentException("Only public class can be proxied : " + target.getName());
            }
            if (Modifier.isFinal(mod)) {
                throw new IllegalArgumentException("final class can not be proxied : " + target.getName());
            }
            if (Modifier.isAbstract(mod)) {
                if (this.enableDubbo == null) {
                    this.enableDubbo = AopManager.me().getEnableDubbo();
                }
                if (this.enableDubbo != null && this.enableDubbo.booleanValue()) {
                    return Dubbo.get(target);
                }
                throw new IllegalArgumentException("abstract class or interface can not be proxied : " + target.getName());
            }
            return this.getProxyClass(target).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> getProxyClass(Class<T> target) throws ReflectiveOperationException {
        Class<T> clazz = target;
        synchronized (clazz) {
            Class<?> ret = this.cache.get(target);
            if (ret != null) {
                return ret;
            }
            ProxyClass proxyClass = this.proxyGenerator.generate(target);
            if (proxyClass.needProxy()) {
                this.proxyCompiler.compile(proxyClass);
                ret = this.proxyClassLoader.loadProxyClass(proxyClass);
                proxyClass.setClazz(ret);
                this.cacheMethodProxy(proxyClass);
                this.cache.put(target, ret);
                return ret;
            }
            this.cache.put(target, target);
            return target;
        }
    }

    protected void cacheMethodProxy(ProxyClass proxyClass) {
        for (ProxyMethod m : proxyClass.getProxyMethodList()) {
            m.setProxyClass(proxyClass.getClazz());
            ProxyMethodCache.put(m);
        }
    }

    public void setProxyGenerator(ProxyGenerator proxyGenerator) {
        Objects.requireNonNull(proxyGenerator, "proxyGenerator can not be null");
        this.proxyGenerator = proxyGenerator;
    }

    public ProxyGenerator getProxyGenerator() {
        return this.proxyGenerator;
    }

    public void setProxyCompiler(ProxyCompiler proxyCompiler) {
        Objects.requireNonNull(proxyCompiler, "proxyCompiler can not be null");
        this.proxyCompiler = proxyCompiler;
    }

    public ProxyCompiler getProxyCompiler() {
        return this.proxyCompiler;
    }

    public void setProxyClassLoader(ProxyClassLoader proxyClassLoader) {
        Objects.requireNonNull(proxyClassLoader, "proxyClassLoader can not be null");
        this.proxyClassLoader = proxyClassLoader;
    }

    public ProxyClassLoader getProxyClassLoader() {
        return this.proxyClassLoader;
    }

    public void clean() {
        this.proxyClassLoader = new ProxyClassLoader();
        this.cache.clear();
    }
}

