/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.litongjava.jfinal.aop.AopManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Dubbo {
    private static final Map<Class<?>, Object> dubboCache = new ConcurrentHashMap();
    private static final Map<Class<?>, ReferenceConfig<?>> referenceMap = new ConcurrentHashMap();
    private static ApplicationConfig applicationConfig;
    private static RegistryConfig registryConfig;
    private static int defaultTimeout;

    public static void initialize(ApplicationConfig appConfig, RegistryConfig regConfig, int timeout) {
        applicationConfig = appConfig;
        registryConfig = regConfig;
        defaultTimeout = timeout;
    }

    public static ApplicationConfig getApplicationConfig() {
        return applicationConfig;
    }

    public static RegistryConfig getRegistryConfig() {
        return registryConfig;
    }

    public static <T> ReferenceConfig<T> getReference(Class<T> targetClass) {
        return referenceMap.get(targetClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(Class<T> targetClass) {
        Object ret = dubboCache.get(targetClass);
        if (ret != null) {
            return (T)ret;
        }
        Class<Dubbo> clazz = Dubbo.class;
        synchronized (Dubbo.class) {
            ret = dubboCache.get(targetClass);
            if (ret != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (T)ret;
            }
            ReferenceConfig reference = new ReferenceConfig();
            reference.setInterface(targetClass);
            reference.setApplication(applicationConfig);
            reference.setRegistry(registryConfig);
            reference.setTimeout(Integer.valueOf(defaultTimeout));
            referenceMap.put(targetClass, reference);
            Object result = null;
            try {
                result = reference.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (result != null) {
                AopManager.me().addSingletonObject(targetClass, result);
                dubboCache.put(targetClass, result);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (T)result;
        }
    }

    public static void clear() {
        referenceMap.clear();
        dubboCache.clear();
    }
}

