/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.jfinal.aop.AopBefore;
import com.litongjava.jfinal.aop.AopClear;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorManager {
    public static final AopInterceptor[] NULL_INTERS = new AopInterceptor[0];
    private AopInterceptor[] globalActionInters = NULL_INTERS;
    private AopInterceptor[] globalServiceInters = NULL_INTERS;
    private final ConcurrentHashMap<Class<? extends AopInterceptor>, AopInterceptor> singletonMap = new ConcurrentHashMap(32, 0.5f);
    private final ConcurrentHashMap<Class<?>, AopInterceptor[]> serviceClassInters = new ConcurrentHashMap(32, 0.5f);
    private static final InterceptorManager me = new InterceptorManager();

    private InterceptorManager() {
    }

    public static InterceptorManager me() {
        return me;
    }

    public AopInterceptor[] createServiceInterceptor(Class<?> serviceClass) {
        AopInterceptor[] result = this.serviceClassInters.get(serviceClass);
        if (result == null) {
            result = this.createInterceptor(serviceClass.getAnnotation(AopBefore.class));
            this.serviceClassInters.put(serviceClass, result);
        }
        return result;
    }

    public AopInterceptor[] buildServiceMethodInterceptor(Class<?> serviceClass, Method method) {
        return this.doBuild(this.globalServiceInters, NULL_INTERS, this.createServiceInterceptor(serviceClass), serviceClass, method);
    }

    private AopInterceptor[] doBuild(AopInterceptor[] globalInters, AopInterceptor[] routesInters, AopInterceptor[] classInters, Class<?> targetClass, Method method) {
        Class<? extends AopInterceptor>[] clearIntersOnClass;
        AopClear clearOnClass;
        Class<? extends AopInterceptor>[] clearIntersOnMethod;
        AopInterceptor[] methodInters = this.createInterceptor(method.getAnnotation(AopBefore.class));
        AopClear clearOnMethod = method.getAnnotation(AopClear.class);
        if (clearOnMethod != null) {
            clearIntersOnMethod = clearOnMethod.value();
            if (clearIntersOnMethod.length == 0) {
                return methodInters;
            }
        } else {
            clearIntersOnMethod = null;
        }
        if ((clearOnClass = targetClass.getAnnotation(AopClear.class)) != null) {
            clearIntersOnClass = clearOnClass.value();
            if (clearIntersOnClass.length == 0) {
                globalInters = NULL_INTERS;
                routesInters = NULL_INTERS;
            }
        } else {
            clearIntersOnClass = null;
        }
        ArrayList<AopInterceptor> result = new ArrayList<AopInterceptor>(globalInters.length + routesInters.length + classInters.length + methodInters.length);
        for (AopInterceptor inter : globalInters) {
            result.add(inter);
        }
        for (AopInterceptor inter : routesInters) {
            result.add(inter);
        }
        if (clearIntersOnClass != null && clearIntersOnClass.length > 0) {
            this.removeInterceptor(result, clearIntersOnClass);
        }
        for (AopInterceptor inter : classInters) {
            result.add(inter);
        }
        if (clearIntersOnMethod != null && clearIntersOnMethod.length > 0) {
            this.removeInterceptor(result, clearIntersOnMethod);
        }
        for (AopInterceptor inter : methodInters) {
            result.add(inter);
        }
        return result.toArray(new AopInterceptor[result.size()]);
    }

    private void removeInterceptor(ArrayList<AopInterceptor> target, Class<? extends AopInterceptor>[] clearInters) {
        Iterator<AopInterceptor> it = target.iterator();
        block0: while (it.hasNext()) {
            AopInterceptor curInter = it.next();
            if (curInter != null) {
                Class<?> curInterClass = curInter.getClass();
                for (Class<? extends AopInterceptor> ci : clearInters) {
                    if (curInterClass != ci) continue;
                    it.remove();
                    continue block0;
                }
                continue;
            }
            it.remove();
        }
    }

    public AopInterceptor[] createInterceptor(AopBefore beforeAnnotation) {
        if (beforeAnnotation == null) {
            return NULL_INTERS;
        }
        return this.createInterceptor(beforeAnnotation.value());
    }

    public AopInterceptor[] createInterceptor(Class<? extends AopInterceptor>[] interceptorClasses) {
        if (interceptorClasses == null || interceptorClasses.length == 0) {
            return NULL_INTERS;
        }
        AopInterceptor[] result = new AopInterceptor[interceptorClasses.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.singletonMap.get(interceptorClasses[i]);
                if (result[i] != null) continue;
                result[i] = interceptorClasses[i].newInstance();
                if (AopManager.me().isInjectDependency()) {
                    Aop.inject(result[i]);
                }
                this.singletonMap.put(interceptorClasses[i], result[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addGlobalActionInterceptor(AopInterceptor ... inters) {
        this.addGlobalInterceptor(true, inters);
    }

    public void addGlobalServiceInterceptor(AopInterceptor ... inters) {
        this.addGlobalInterceptor(false, inters);
    }

    private synchronized void addGlobalInterceptor(boolean forAction, AopInterceptor ... inters) {
        if (inters == null || inters.length == 0) {
            throw new IllegalArgumentException("interceptors can not be null.");
        }
        for (AopInterceptor inter : inters) {
            if (inter == null) {
                throw new IllegalArgumentException("interceptor can not be null.");
            }
            if (!this.singletonMap.containsKey(inter.getClass())) continue;
            throw new IllegalArgumentException("interceptor already exists, interceptor must be singlton, do not create more then one instance of the same Interceptor Class.");
        }
        for (AopInterceptor inter : inters) {
            if (AopManager.me().isInjectDependency()) {
                Aop.inject(inter);
            }
            this.singletonMap.put(inter.getClass(), inter);
        }
        AopInterceptor[] globalInters = forAction ? this.globalActionInters : this.globalServiceInters;
        AopInterceptor[] temp = new AopInterceptor[globalInters.length + inters.length];
        System.arraycopy(globalInters, 0, temp, 0, globalInters.length);
        System.arraycopy(inters, 0, temp, globalInters.length, inters.length);
        if (forAction) {
            this.globalActionInters = temp;
        } else {
            this.globalServiceInters = temp;
        }
    }

    public List<Class<?>> getGlobalServiceInterceptorClasses() {
        ArrayList ret = new ArrayList(this.globalServiceInters.length + 3);
        for (AopInterceptor i : this.globalServiceInters) {
            ret.add(i.getClass());
        }
        return ret;
    }
}

