/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop;

import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.proxy.Callback;
import com.litongjava.jfinal.proxy.ProxyMethod;
import com.litongjava.jfinal.proxy.ProxyMethodCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AopInvocation {
    private static final Object[] NULL_ARGS = new Object[0];
    private Object target;
    private Method method;
    private Object[] args;
    private Callback callback;
    private AopInterceptor[] inters;
    private Object returnValue;
    private int index = 0;

    public AopInvocation(Object target, Long proxyMethodKey, Callback callback, Object ... args) {
        this.target = target;
        ProxyMethod proxyMethod = ProxyMethodCache.get(proxyMethodKey);
        this.method = proxyMethod.getMethod();
        this.inters = proxyMethod.getInterceptors();
        this.callback = callback;
        this.args = args;
    }

    public AopInvocation(Object target, Long proxyMethodKey, Callback callback) {
        this(target, proxyMethodKey, callback, NULL_ARGS);
    }

    public AopInvocation(Object target, Method method, AopInterceptor[] inters, Callback callback, Object[] args) {
        this.target = target;
        this.method = method;
        this.inters = inters;
        this.callback = callback;
        this.args = args;
    }

    protected AopInvocation() {
    }

    public Object invoke() {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ == this.inters.length) {
            try {
                this.returnValue = this.callback.call(this.args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return this.returnValue;
    }

    public Object getArg(int index) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.args[index];
    }

    public void setArg(int index, Object value) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.args[index] = value;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public <T> T getTarget() {
        return (T)this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public <T> T getReturnValue() {
        return (T)this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }
}

