/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop;

import com.litongjava.annotation.Inject;
import com.litongjava.jfinal.aop.AopManager;
import com.litongjava.jfinal.aop.Singleton;
import com.litongjava.jfinal.model.DestroyableBean;
import com.litongjava.jfinal.proxy.Proxy;
import com.litongjava.jfinal.proxy.ProxyMethodCache;
import com.litongjava.jfinal.spring.SpringBeanContextUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AopFactory {
    private static final Logger log = LoggerFactory.getLogger(AopFactory.class);
    protected Map<Class<?>, Object> singletonCache = new ConcurrentHashMap();
    protected ThreadLocal<HashMap<Class<?>, Object>> singletonTl = this.initThreadLocalHashMap();
    protected ThreadLocal<HashMap<Class<?>, Object>> prototypeTl = this.initThreadLocalHashMap();
    protected HashMap<Class<?>, Class<?>> mapping = null;
    protected boolean singleton = true;
    protected boolean injectSuperClass = false;
    protected List<DestroyableBean> destroyableBeans = new ArrayList<DestroyableBean>();
    private List<Class<? extends Annotation>> fetchBeanAnnotations = new ArrayList<Class<? extends Annotation>>();
    private Boolean enableWithSpring = AopManager.me().getEnableWithSpring();

    public ThreadLocal<HashMap<Class<?>, Object>> initThreadLocalHashMap() {
        return new ThreadLocal<HashMap<Class<?>, Object>>(){

            @Override
            protected HashMap<Class<?>, Object> initialValue() {
                return new HashMap();
            }
        };
    }

    public <T> T get(Class<T> targetClass) {
        try {
            return this.doGet(targetClass);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getWithMapping(Class<T> targetClass, Map<Class<Object>, Class<? extends Object>> interfaceMapping) {
        try {
            return this.doGetgetWithMapping(targetClass, interfaceMapping);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T doGet(Class<T> targetClass, Class<?> intrefaceClass) throws ReflectiveOperationException {
        Singleton si;
        boolean singleton;
        if (this.enableWithSpring == null) {
            this.enableWithSpring = AopManager.me().getEnableWithSpring();
        }
        if (this.enableWithSpring != null && this.enableWithSpring.booleanValue()) {
            try {
                T bean = SpringBeanContextUtils.getBean(targetClass);
                if (bean != null) {
                    return bean;
                }
            }
            catch (Exception bean) {
                // empty catch block
            }
        }
        boolean bl = singleton = (si = (targetClass = this.getMappingClass(targetClass)).getAnnotation(Singleton.class)) != null ? si.value() : this.singleton;
        if (singleton) {
            return (T)this.doGetSingleton(targetClass, intrefaceClass);
        }
        return (T)this.doGetPrototype(targetClass, intrefaceClass);
    }

    public <T> T getSingleton(Class<T> targetClass) {
        try {
            return this.doGetSingleton(targetClass, null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getPrototype(Class<T> targetClass) {
        try {
            return this.doGetPrototype(targetClass, null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doGetSingleton(Class<T> targetClass, Class<?> interfaceClass) throws ReflectiveOperationException {
        Object existing = this.singletonCache.get(targetClass);
        if (existing != null) {
            return (T)existing;
        }
        HashMap<Class<?>, Object> map = this.singletonTl.get();
        int size = map.size();
        Object ret = map.get(targetClass);
        if (ret != null) {
            return (T)ret;
        }
        AopFactory aopFactory = this;
        synchronized (aopFactory) {
            ret = this.singletonCache.get(targetClass);
            if (ret == null) {
                ret = interfaceClass != null ? this.createObject(targetClass, interfaceClass) : this.createObject(targetClass);
            }
            map.put(targetClass, ret);
            this.doInject(targetClass, ret);
            this.singletonCache.put(targetClass, ret);
            Object object = ret;
            return (T)object;
            finally {
                if (size == 0) {
                    this.singletonTl.remove();
                }
            }
        }
    }

    protected <T> T doGet(Class<T> targetClass) throws ReflectiveOperationException {
        return this.doGet(targetClass, null);
    }

    protected <T> T doGetgetWithMapping(Class<T> targetClass, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        Singleton si;
        boolean singleton;
        if (this.enableWithSpring == null) {
            this.enableWithSpring = AopManager.me().getEnableWithSpring();
        }
        if (this.enableWithSpring != null && this.enableWithSpring.booleanValue()) {
            try {
                T bean = SpringBeanContextUtils.getBean(targetClass);
                if (bean != null) {
                    return bean;
                }
            }
            catch (Exception bean) {
                // empty catch block
            }
        }
        boolean bl = singleton = (si = (targetClass = this.getMappingClass(targetClass)).getAnnotation(Singleton.class)) != null ? si.value() : this.singleton;
        if (singleton) {
            return (T)this.doGetSingletonWithMapping(targetClass, interfaceMapping);
        }
        return (T)this.doGetPrototypeWithMapping(targetClass, interfaceMapping);
    }

    protected <T> T doGetgetWithMapping(Class<T> targetClass, Class<?> typeMaybeInterface, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        boolean singleton;
        Singleton si = (targetClass = this.getMappingClass(targetClass)).getAnnotation(Singleton.class);
        boolean bl = singleton = si != null ? si.value() : this.singleton;
        if (singleton) {
            return (T)this.doGetSingletonWithMapping(targetClass, typeMaybeInterface, interfaceMapping);
        }
        return (T)this.doGetPrototypeWithMapping(targetClass, typeMaybeInterface, interfaceMapping);
    }

    protected <T> T doGetSingletonWithMapping(Class<T> targetClass, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        return this.doGetSingletonWithMapping(targetClass, null, interfaceMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doGetSingletonWithMapping(Class<T> targetClass, Class<?> typeMaybeInterface, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        Object ret = this.singletonCache.get(targetClass);
        if (ret != null) {
            return (T)ret;
        }
        HashMap<Class<?>, Object> map = this.singletonTl.get();
        int size = map.size();
        if (size > 0 && (ret = map.get(targetClass)) != null) {
            return (T)ret;
        }
        AopFactory aopFactory = this;
        synchronized (aopFactory) {
            ret = this.singletonCache.get(targetClass);
            if (ret == null) {
                ret = typeMaybeInterface == null ? this.createObject(targetClass) : this.createObject(targetClass, typeMaybeInterface);
                map.put(targetClass, ret);
                this.doInjectWithMapping(targetClass, ret, interfaceMapping);
                this.singletonCache.put(targetClass, ret);
            }
            Object object = ret;
            return (T)object;
            finally {
                if (size == 0) {
                    this.singletonTl.remove();
                }
            }
        }
    }

    protected <T> T doGetSingleton(Class<T> targetClass) throws ReflectiveOperationException {
        return this.doGetSingletonWithMapping(targetClass, null);
    }

    protected <T> T doGetPrototypeWithMapping(Class<T> targetClass, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        return this.doGetPrototypeWithMapping(targetClass, null, interfaceMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doGetPrototypeWithMapping(Class<T> targetClass, Class<?> typeMaybeInterface, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        Object ret;
        HashMap<Class<?>, Object> map = this.prototypeTl.get();
        int size = map.size();
        if (size > 0 && (ret = map.get(targetClass)) != null) {
            if (interfaceMapping != null) {
                return (T)this.createObject(targetClass, typeMaybeInterface);
            }
            return (T)this.createObject(targetClass);
        }
        try {
            ret = interfaceMapping != null ? this.createObject(targetClass, typeMaybeInterface) : this.createObject(targetClass);
            map.put(targetClass, ret);
            this.doInject(targetClass, ret);
            Object object = ret;
            return (T)object;
        }
        finally {
            if (size == 0) {
                map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doGetPrototype(Class<T> targetClass, Class<?> intrefaceClass) throws ReflectiveOperationException {
        Object ret;
        HashMap<Class<?>, Object> map = this.prototypeTl.get();
        int size = map.size();
        if (size > 0 && (ret = map.get(targetClass)) != null) {
            return (T)this.createObject(targetClass, intrefaceClass);
        }
        try {
            ret = this.createObject(targetClass, intrefaceClass);
            map.put(targetClass, ret);
            this.doInject(targetClass, ret);
            Object object = ret;
            return (T)object;
        }
        finally {
            if (size == 0) {
                map.clear();
            }
        }
    }

    protected <T> T doGetPrototype(Class<T> targetClass) throws ReflectiveOperationException {
        return this.doGetPrototypeWithMapping(targetClass, null);
    }

    public <T> T inject(T targetObject) {
        try {
            this.doInject(targetObject.getClass(), targetObject);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T inject(Class<T> targetClass, T targetObject) {
        try {
            this.doInject(targetClass, targetObject);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doInjectWithMapping(Class<?> targetClass, Object targetObject, Map<Class<Object>, Class<? extends Object>> interfaceMapping) throws ReflectiveOperationException {
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                for (Class<? extends Annotation> clazz : this.fetchBeanAnnotations) {
                    if (!field.isAnnotationPresent(clazz)) continue;
                    Class<?> typeMaybeInterface = field.getType();
                    Object fieldInjectedObject = null;
                    if (interfaceMapping != null) {
                        Class<? extends Object> implClazz = interfaceMapping.get(typeMaybeInterface);
                        if (implClazz != null) {
                            fieldInjectedObject = this.doGetgetWithMapping(implClazz, typeMaybeInterface, interfaceMapping);
                            interfaceMapping.remove(typeMaybeInterface);
                        } else {
                            fieldInjectedObject = this.doGetgetWithMapping(typeMaybeInterface, interfaceMapping);
                        }
                    } else {
                        fieldInjectedObject = this.doGet(typeMaybeInterface);
                    }
                    field.setAccessible(true);
                    field.set(targetObject, fieldInjectedObject);
                }
                Inject inject = field.getAnnotation(Inject.class);
                if (inject == null) continue;
                Class<?> fieldInjectedClass = inject.value();
                if (fieldInjectedClass == Void.class) {
                    fieldInjectedClass = field.getType();
                }
                Object fieldInjectedObject = this.doGet(fieldInjectedClass);
                field.setAccessible(true);
                field.set(targetObject, fieldInjectedObject);
            }
        }
    }

    protected void doInject(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                for (Class<? extends Annotation> clazz : this.fetchBeanAnnotations) {
                    if (!field.isAnnotationPresent(clazz)) continue;
                    Class<?> typeMaybeInterface = field.getType();
                    Object fieldInjectedObject = null;
                    fieldInjectedObject = this.doGet(typeMaybeInterface);
                    field.setAccessible(true);
                    field.set(targetObject, fieldInjectedObject);
                }
                Inject inject = field.getAnnotation(Inject.class);
                if (inject == null) continue;
                Class<?> fieldInjectedClass = inject.value();
                if (fieldInjectedClass == Void.class) {
                    fieldInjectedClass = field.getType();
                }
                Object fieldInjectedObject = this.doGet(fieldInjectedClass);
                field.setAccessible(true);
                field.set(targetObject, fieldInjectedObject);
            }
        }
    }

    protected Object createObject(Class<?> targetClass) throws ReflectiveOperationException {
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces.length > 0) {
            this.addMapping(interfaces[0], targetClass);
        }
        return Proxy.get(targetClass);
    }

    protected Object createObject(Class<?> targetClass, Class<?> intrefaceClass) {
        if (intrefaceClass != null) {
            this.addMapping(intrefaceClass, targetClass);
        }
        return Proxy.get(targetClass);
    }

    protected Class<?> getUsefulClass(Class<?> clazz) {
        String n = clazz.getName();
        return n.indexOf("_$$_") > -1 || n.indexOf("$$Enhancer") > -1 ? clazz.getSuperclass() : clazz;
    }

    public AopFactory setSingleton(boolean singleton) {
        this.singleton = singleton;
        return this;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public AopFactory setInjectSuperClass(boolean injectSuperClass) {
        this.injectSuperClass = injectSuperClass;
        return this;
    }

    public boolean isInjectSuperClass() {
        return this.injectSuperClass;
    }

    public AopFactory addSingletonObject(Class<?> type, Object singletonObject) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        if (singletonObject == null) {
            throw new IllegalArgumentException("singletonObject can not be null");
        }
        if (singletonObject instanceof Class) {
            throw new IllegalArgumentException("singletonObject can not be Class type");
        }
        if (!type.isAssignableFrom(singletonObject.getClass())) {
            throw new IllegalArgumentException(singletonObject.getClass().getName() + " can not cast to " + type.getName());
        }
        if (this.singletonCache.putIfAbsent(type, singletonObject) != null) {
            throw new RuntimeException("Singleton object already exists for type : " + type.getName());
        }
        return this;
    }

    public AopFactory addSingletonObject(Object singletonObject) {
        Class<?> type = this.getUsefulClass(singletonObject.getClass());
        return this.addSingletonObject(type, singletonObject);
    }

    public synchronized <T> AopFactory addMapping(Class<? extends T> from, Class<? extends T> to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        } else if (this.mapping.containsKey(from)) {
            log.warn("Class already mapped : " + from.getName());
        }
        this.mapping.put(from, to);
        return this;
    }

    public <T> AopFactory addMapping(Class<T> from, String to) {
        try {
            Class<?> toClass = Class.forName(to.trim());
            if (from.isAssignableFrom(toClass)) {
                return this.addMapping(from, toClass);
            }
            throw new IllegalArgumentException("The parameter \"to\" must be the subclass or implementation of the parameter \"from\"");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getMappingClass(Class<?> from) {
        if (this.mapping != null) {
            Class<?> ret = this.mapping.get(from);
            return ret != null ? ret : from;
        }
        return from;
    }

    public void register(Class<?> targetClass, Object value) {
        HashMap<Class<?>, Object> map = this.singletonTl.get();
        map.put(targetClass, value);
        try {
            this.doInject(targetClass, value);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        this.singletonCache.put(targetClass, value);
    }

    public <T> T getOnly(Class<T> type) {
        Class<?> usefulClass = this.getUsefulClass(type);
        Class<?> mappingClass = this.getMappingClass(usefulClass);
        Object object = this.singletonCache.get(mappingClass);
        if (object != null) {
            return (T)object;
        }
        return null;
    }

    public boolean contains(Class<?> type) {
        type = this.getUsefulClass(type);
        Class<?> mappingClass = this.getMappingClass(type);
        return this.singletonCache.containsKey(mappingClass);
    }

    public String[] beans() {
        return (String[])this.singletonCache.values().stream().map(Object::toString).toArray(String[]::new);
    }

    public void clean() {
        this.singletonCache = new ConcurrentHashMap();
        Proxy.clean();
        ProxyMethodCache.clean();
        this.singletonTl = this.initThreadLocalHashMap();
        this.prototypeTl = this.initThreadLocalHashMap();
        this.mapping = null;
        for (DestroyableBean bean : this.destroyableBeans) {
            try {
                bean.getDestroyMethod().invoke(bean.getBean(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void addDestroyableBeans(List<DestroyableBean> destroyableBeans) {
        this.destroyableBeans.addAll(destroyableBeans);
    }

    public void addFetchBeanAnnotation(Class<? extends Annotation> claszz) {
        this.fetchBeanAnnotations.add(claszz);
    }

    public void addFetchBeanAnnotations(Class<? extends Annotation>[] classes) {
        for (Class<? extends Annotation> clazz : classes) {
            this.fetchBeanAnnotations.add(clazz);
        }
    }
}

