/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.volcengine;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.base64.Base64Utils;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.volcengine.VolcApp;
import com.litongjava.volcengine.VolcAudio;
import com.litongjava.volcengine.VolcRequest;
import com.litongjava.volcengine.VolcTtsRequest;
import com.litongjava.volcengine.VolcTtsResponse;
import com.litongjava.volcengine.VolcUser;
import java.io.IOException;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class VolceTtsClient {
    public static final String API_URL = "https://openspeech.bytedance.com/api/v1/tts";

    public static byte[] tts(String input) {
        String appid = EnvUtils.getStr((String)"VOLC_APP_ID");
        String accessToken = EnvUtils.getStr((String)"VOLC_ACCESS_TOKEN");
        return VolceTtsClient.tts(input, appid, accessToken);
    }

    public static byte[] tts(String input, String appid, String accessToken) {
        VolcAudio audio = VolcAudio.builder().encoding("mp3").voice_type("zh_male_beijingxiaoye_moon_bigtts").build();
        VolcRequest request = VolcRequest.builder().reqid(UUID.randomUUID().toString()).operation("query").text(input).build();
        VolcTtsRequest ttsRequest = VolcTtsRequest.builder().app(VolcApp.builder().appid(appid).cluster("volcano_tts").build()).user(VolcUser.builder().uid("uid").build()).audio(audio).request(request).build();
        VolcTtsResponse response = VolceTtsClient.tts(accessToken, ttsRequest);
        Integer code = response.getCode();
        if (code.equals(3000)) {
            return Base64Utils.decodeToBytes((String)response.getData());
        }
        String message = response.getMessage();
        throw new RuntimeException("Failed to tts code:" + code + ",message" + message);
    }

    public static VolcTtsResponse tts(String accessToken, VolcTtsRequest ttsRequest) {
        String reqBody = JsonUtils.toSkipNullJson((Object)ttsRequest);
        ResponseVo responseVo = VolceTtsClient.execute(accessToken, reqBody);
        if (responseVo.isOk()) {
            String bodyString = responseVo.getBodyString();
            return (VolcTtsResponse)JsonUtils.parse((String)bodyString, VolcTtsResponse.class);
        }
        throw new RuntimeException(responseVo.getBodyString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResponseVo execute(String accessToken, String reqBody) {
        RequestBody body = RequestBody.create((String)reqBody, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(API_URL).header("Authorization", "Bearer;" + accessToken).post(body).build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((String)responseBody);
                return responseVo;
            }
            ResponseVo responseVo = ResponseVo.fail((int)code, (String)responseBody);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

