/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.textin;

import com.litongjava.textin.PdfToMarkdownParams;
import com.litongjava.textin.PdfToMarkdownResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TextinOcrClient {
    private static final MediaType MEDIA_TYPE_OCTET_STREAM = MediaType.parse((String)"application/octet-stream");
    private static final OkHttpClient client = OkHttpClientPool.get3600HttpClient();

    public static PdfToMarkdownResponse convertPdfToMarkdown(byte[] pdfFile, PdfToMarkdownParams params) {
        String url = EnvUtils.getStr((String)"x_ti_api_url");
        if (url == null) {
            url = "https://api.textin.com/ai/service/v1/pdf_to_markdown";
        }
        String appId = EnvUtils.getStr((String)"x_ti_app_id");
        String appSecret = EnvUtils.getStr((String)"x_ti_secret_code");
        return TextinOcrClient.convertPdfToMarkdown(url, appId, appSecret, pdfFile, params);
    }

    public static PdfToMarkdownResponse convertPdfToMarkdown(String url, String appId, String appSecret, byte[] pdfFile, PdfToMarkdownParams params) {
        url = TextinOcrClient.buildUrl(url, params);
        String responseBody = TextinOcrClient.convertPdfToMarkdown(url, appId, appSecret, pdfFile);
        return (PdfToMarkdownResponse)JsonUtils.parse((String)responseBody, PdfToMarkdownResponse.class);
    }

    public static String convertPdfToMarkdown(String url, String appId, String appSecret, byte[] pdfFile) {
        RequestBody body = RequestBody.create((byte[])pdfFile, (MediaType)MEDIA_TYPE_OCTET_STREAM);
        Request request = new Request.Builder().url(url).post(body).addHeader("x-ti-app-id", appId).addHeader("x-ti-secret-code", appSecret).build();
        String responseBody = null;
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new RuntimeException("Unexpected code:" + response + " body:" + response.body().string());
            }
            responseBody = response.body().string();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return responseBody;
    }

    private static String buildUrl(String url, PdfToMarkdownParams params) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params.getPdfPwd() != null) {
            urlBuilder.addQueryParameter("pdf_pwd", params.getPdfPwd());
        }
        if (params.getDpi() != null) {
            urlBuilder.addQueryParameter("dpi", params.getDpi().toString());
        }
        if (params.getPageStart() != null) {
            urlBuilder.addQueryParameter("page_start", params.getPageStart().toString());
        }
        if (params.getPageCount() != null) {
            urlBuilder.addQueryParameter("page_count", params.getPageCount().toString());
        }
        if (params.getApplyDocumentTree() != null) {
            urlBuilder.addQueryParameter("apply_document_tree", params.getApplyDocumentTree().toString());
        }
        if (params.getMarkdownDetails() != null) {
            urlBuilder.addQueryParameter("markdown_details", params.getMarkdownDetails());
        }
        if (params.getTableFlavor() != null) {
            urlBuilder.addQueryParameter("table_flavor", params.getTableFlavor());
        }
        if (params.getGetImage() != null) {
            urlBuilder.addQueryParameter("get_image", params.getGetImage());
        }
        if (params.getParseMode() != null) {
            urlBuilder.addQueryParameter("parse_mode", params.getParseMode());
        }
        return urlBuilder.build().toString();
    }
}

