/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tavily;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tavily.TavilyExtractRequest;
import com.litongjava.tavily.TavilyExtractResponse;
import com.litongjava.tavily.TavilySearchRequest;
import com.litongjava.tavily.TavilySearchResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonUtils;

public class TavilyClient {
    public static final String TAVILY_API_BASE = "https://api.tavily.com";

    public static TavilySearchResponse search(TavilySearchRequest request) {
        String requestJson = JsonUtils.toSkipNullJson((Object)request);
        String apiBase = EnvUtils.getStr((String)"TAVILY_API_BASE", (String)TAVILY_API_BASE);
        String url = apiBase + "/search";
        String token = EnvUtils.getStr((String)"TAVILY_API_TOKEN");
        if (StrUtil.isBlank((CharSequence)token)) {
            throw new RuntimeException("TAVILY_API_TOKEN can not be empty");
        }
        ResponseVo responseVo = HttpUtils.postJson((String)url, (String)token, (String)requestJson);
        int code = responseVo.getCode();
        String bodyString = responseVo.getBodyString();
        if (!responseVo.isOk()) {
            throw new RuntimeException("request:" + requestJson + " response code:" + code + " response body:" + bodyString);
        }
        return (TavilySearchResponse)JsonUtils.parse((String)bodyString, TavilySearchResponse.class);
    }

    public static TavilySearchResponse search(String query) {
        TavilySearchRequest request = TavilySearchRequest.builder().query(query).topic("general").search_depth("basic").chunks_perSource(3).max_results(4).include_answer(false).include_raw_content(true).include_images(false).include_image_descriptions(false).build();
        return TavilyClient.search(request);
    }

    public static TavilyExtractResponse extract(TavilyExtractRequest request) {
        String requestJson = JsonUtils.toJson((Object)request);
        String apiBase = EnvUtils.getStr((String)"TAVILY_API_BASE", (String)TAVILY_API_BASE);
        String url = apiBase + "/extract";
        String token = EnvUtils.getStr((String)"TAVILY_API_TOKEN");
        ResponseVo responseVo = HttpUtils.postJson((String)url, (String)token, (String)requestJson);
        int code = responseVo.getCode();
        String bodyString = responseVo.getBodyString();
        if (!responseVo.isOk()) {
            throw new RuntimeException("request:" + requestJson + " response code:" + code + " response body:" + bodyString);
        }
        return (TavilyExtractResponse)JsonUtils.parse((String)bodyString, TavilyExtractResponse.class);
    }

    public static TavilyExtractResponse extract(String url) {
        TavilyExtractRequest request = TavilyExtractRequest.builder().urls(url).include_images(false).extract_depth("basic").build();
        return TavilyClient.extract(request);
    }
}

