/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.supadata;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.supadata.SubTitleResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.json.FastJson2Utils;
import java.util.HashMap;
import okhttp3.Response;

public class SupadataClient {
    public static final String target = "https://api.supadata.ai/v1/youtube/transcript?videoId=%s";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo get(String videoId) {
        String targetUrl = String.format(target, videoId);
        String apiKey = EnvUtils.getStr((String)"SUPADATA_API_KEY");
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("x-api-key", apiKey);
        try (Response response = HttpUtils.get((String)targetUrl, header);){
            String string = response.body().string();
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((String)string);
                return responseVo;
            }
            ResponseVo responseVo = ResponseVo.fail((int)code, (String)string);
            return responseVo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SubTitleResponse getSubTitle(String videoId) {
        ResponseVo responseVo = SupadataClient.get(videoId);
        if (responseVo.isOk()) {
            return (SubTitleResponse)FastJson2Utils.parse((String)responseVo.getBodyString(), SubTitleResponse.class);
        }
        return null;
    }
}

