/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jian.reader;

import com.litongjava.jian.reader.JinaReaderRequest;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JinaReaderClient {
    private static final Logger log = LoggerFactory.getLogger(JinaReaderClient.class);
    private static final OkHttpClient client = OkHttpClientPool.get120HttpClient();

    public static ResponseVo read(JinaReaderRequest request) {
        String endpoint = request.getEndpoint() == null ? "https://r.jina.ai/" : request.getEndpoint();
        String url = endpoint + request.getUrl();
        Request.Builder builder = new Request.Builder().url(url);
        ResponseVo responseVo = new ResponseVo();
        if (request.getAuthorization() != null) {
            builder.header("Authorization", "Bearer " + request.getAuthorization());
        } else {
            String key = EnvUtils.getStr((String)"JINA_API_KEY");
            if (key == null) {
                responseVo.setOk(false);
                responseVo.setBodyString("JINA_API_KEY is null");
                return responseVo;
            }
            builder.header("Authorization", "Bearer " + key);
        }
        if (request.getContentType() != null) {
            builder.header("Content-Type", request.getContentType());
        }
        if (request.getXRetainImages() != null) {
            builder.header("X-Retain-Images", request.getXRetainImages());
        }
        if (request.getXRespondWith() != null) {
            builder.header("X-Respond-With", request.getXRespondWith());
        }
        if (request.getXWithGeneratedAlt() != null) {
            builder.header("X-With-Generated-Alt", request.getXWithGeneratedAlt());
        }
        if (request.getXWithLinksSummary() != null) {
            builder.header("X-With-Links-Summary", request.getXWithLinksSummary());
        }
        builder.get();
        try {
            Request okHttpRequest = builder.build();
            try (Response response = client.newCall(okHttpRequest).execute();){
                int code = response.code();
                responseVo.setCode(code);
                responseVo.setOk(code >= 200 && code < 300);
                ResponseBody responseBody = response.body();
                String bodyString = responseBody == null ? "" : responseBody.string();
                responseVo.setBodyString(bodyString);
                HashMap<String, String> headersMap = new HashMap<String, String>();
                Headers headers = response.headers();
                for (String name : headers.names()) {
                    headersMap.put(name, headers.get(name));
                }
                responseVo.setHeadersMap(headersMap);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            responseVo.setOk(false);
            responseVo.setBodyString(e.getMessage());
        }
        return responseVo;
    }

    public static String read(String url) {
        JinaReaderRequest request = new JinaReaderRequest();
        request.setUrl(url);
        request.setXRetainImages("none");
        ResponseVo vo = JinaReaderClient.read(request);
        String bodyString = vo.getBodyString();
        if (vo.isOk()) {
            return bodyString;
        }
        int code = vo.getCode();
        throw new RuntimeException("code:" + code + " body:" + bodyString);
    }
}

