/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.groq;

import com.litongjava.groq.GroqSpeechClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class GroqSpeechRequestLimiter {
    private final int allowedRequestsPerMinute;
    private int currentRequestCount = 0;
    private long minuteStart = System.currentTimeMillis();
    private final ByteArrayOutputStream mergedAudio = new ByteArrayOutputStream();
    private ScheduledFuture<?> scheduledFlush = null;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public GroqSpeechRequestLimiter(int allowedRequestsPerMinute) {
        this.allowedRequestsPerMinute = allowedRequestsPerMinute;
    }

    public boolean canSendRequest() {
        long now = System.currentTimeMillis();
        if (now - this.minuteStart >= 60000L) {
            this.minuteStart = now;
            this.currentRequestCount = 0;
        }
        return this.currentRequestCount < this.allowedRequestsPerMinute;
    }

    public void recordRequest() {
        ++this.currentRequestCount;
    }

    public void appendAudio(byte[] audioData) throws IOException {
        this.mergedAudio.write(audioData);
    }

    public boolean hasMergedAudio() {
        return this.mergedAudio.size() > 0;
    }

    public byte[] flushMergedAudio() {
        byte[] data = this.mergedAudio.toByteArray();
        this.mergedAudio.reset();
        return data;
    }

    public void scheduleFlush(String model, String audioMimeType, String audioFileName, Consumer<String> callback) {
        if (this.scheduledFlush == null || this.scheduledFlush.isDone()) {
            long delay = 60000L - (System.currentTimeMillis() - this.minuteStart);
            if (delay < 0L) {
                delay = 0L;
            }
            this.scheduledFlush = scheduler.schedule(() -> {
                GroqSpeechRequestLimiter groqSpeechRequestLimiter = this;
                synchronized (groqSpeechRequestLimiter) {
                    if (this.hasMergedAudio() && this.canSendRequest()) {
                        byte[] merged = this.flushMergedAudio();
                        GroqSpeechClient.sendMergedRequest(model, merged, audioMimeType, audioFileName, callback);
                        this.recordRequest();
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }
}

