/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.groq;

import com.litongjava.groq.GroqSpeechRequestLimiter;
import com.litongjava.groq.TranscriptionsRequest;
import com.litongjava.groq.TranscriptionsResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class GroqSpeechClient {
    private static final OkHttpClient client = OkHttpClientPool.get60HttpClient();
    private static final Map<String, GroqSpeechRequestLimiter> limiters = new HashMap<String, GroqSpeechRequestLimiter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transcribe(byte[] audioData, String model, String audioMimeType, String audioFileName, Consumer<String> callback) {
        GroqSpeechRequestLimiter limiter;
        GroqSpeechRequestLimiter groqSpeechRequestLimiter = limiter = limiters.getOrDefault(model, new GroqSpeechRequestLimiter(100));
        synchronized (groqSpeechRequestLimiter) {
            if (limiter.canSendRequest()) {
                GroqSpeechClient.sendTranscriptionRequest(audioData, model, audioMimeType, audioFileName, callback);
                limiter.recordRequest();
            } else {
                try {
                    limiter.appendAudio(audioData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                limiter.scheduleFlush(model, audioMimeType, audioFileName, callback);
            }
        }
    }

    public static TranscriptionsResponse transcriptions(byte[] audioData, String filename, TranscriptionsRequest reqVo) {
        String suffix = FilenameUtils.getSuffix((String)filename);
        String contentType = ContentTypeUtils.getContentType((String)suffix);
        RequestBody fileRequestPart = RequestBody.create((byte[])audioData, (MediaType)MediaType.get((String)contentType));
        return GroqSpeechClient.transcriptions(fileRequestPart, filename, reqVo);
    }

    public static TranscriptionsResponse transcriptions(File file, TranscriptionsRequest reqVo) {
        String suffix = FilenameUtils.getSuffix((String)file.getName());
        String contentType = ContentTypeUtils.getContentType((String)suffix);
        RequestBody fileRequestPart = RequestBody.create((File)file, (MediaType)MediaType.get((String)contentType));
        return GroqSpeechClient.transcriptions(fileRequestPart, file.getName(), reqVo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TranscriptionsResponse transcriptions(RequestBody fileRequestPart, String filename, TranscriptionsRequest reqVo) {
        String apiBase = EnvUtils.getStr((String)"GROQ_API_BASE", (String)"https://api.groq.com");
        String endpoint = apiBase + "/openai/v1/audio/transcriptions";
        String apiKey = EnvUtils.getStr((String)"GROQ_API_KEY");
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        bodyBuilder.addFormDataPart("file", filename, fileRequestPart);
        String model = reqVo.getModel();
        if (model != null) {
            model = "whisper-large-v3-turbo";
        }
        bodyBuilder.addFormDataPart("model", model);
        if (reqVo.getTemperature() != null) {
            bodyBuilder.addFormDataPart("temperature", reqVo.getTemperature().toString());
        }
        if (reqVo.getResponse_format() != null) {
            bodyBuilder.addFormDataPart("response_format", reqVo.getResponse_format());
        }
        MultipartBody multipartBody = bodyBuilder.build();
        Request request = new Request.Builder().url(endpoint).method("POST", (RequestBody)multipartBody).addHeader("Authorization", "Bearer " + apiKey).build();
        Call newCall = client.newCall(request);
        try (Response response = newCall.execute();){
            if (response.isSuccessful()) {
                TranscriptionsResponse transcriptionsResponse;
                String string = response.body().string();
                TranscriptionsResponse transcriptionsResponse2 = transcriptionsResponse = (TranscriptionsResponse)JsonUtils.parse((String)string, TranscriptionsResponse.class);
                return transcriptionsResponse2;
            }
            String message = "code:" + response.code() + ",body:" + response.body().string();
            throw new RuntimeException(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendMergedRequest(String model, byte[] audioData, String audioMimeType, String audioFileName, Consumer<String> callback) {
        GroqSpeechClient.sendTranscriptionRequest(audioData, model, audioMimeType, audioFileName, callback);
    }

    private static void sendTranscriptionRequest(byte[] audioData, String model, String audioMimeType, String audioFileName, final Consumer<String> callback) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("model", model).addFormDataPart("temperature", "0").addFormDataPart("response_format", "json");
        RequestBody fileBody = RequestBody.create((byte[])audioData, (MediaType)MediaType.parse((String)audioMimeType));
        multipartBuilder.addFormDataPart("file", audioFileName, fileBody);
        String apiBase = EnvUtils.getStr((String)"GROQ_API_BASE", (String)"https://api.groq.com");
        String endpoint = apiBase + "/openai/v1/audio/transcriptions";
        String apiKey = EnvUtils.getStr((String)"GROQ_API_KEY");
        Request request = new Request.Builder().url(endpoint).header("Authorization", "bearer " + apiKey).post((RequestBody)multipartBuilder.build()).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                callback.accept("Transcription failed: " + e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    callback.accept("Transcription error: code:" + response.code() + " body:" + response.body().string());
                } else {
                    String responseBody = response.body().string();
                    String transcript = GroqSpeechClient.parseTranscript(responseBody);
                    callback.accept(transcript);
                }
            }
        });
    }

    private static String parseTranscript(String responseBody) {
        int index = responseBody.indexOf("\"text\":");
        if (index != -1) {
            int start = responseBody.indexOf("\"", index + 7) + 1;
            int end = responseBody.indexOf("\"", start);
            if (start != -1 && end != -1) {
                return responseBody.substring(start, end);
            }
        }
        return responseBody;
    }

    static {
        limiters.put("whisper-large-v3", new GroqSpeechRequestLimiter(100));
        limiters.put("whisper-large-v3-turbo", new GroqSpeechRequestLimiter(400));
        limiters.put("distil-whisper-large-v3-en", new GroqSpeechRequestLimiter(100));
    }
}

