/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.fishaudio.tts;

import com.litongjava.fishaudio.tts.FishAudioReferenceAudio;
import com.litongjava.fishaudio.tts.FishAudioTTSRequestVo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class FishAudioMsgPackConverter {
    public static byte[] encodeFishAudioTTSRequestVo(FishAudioTTSRequestVo vo) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            FishAudioMsgPackConverter.writeMapHeader(out, 8);
            FishAudioMsgPackConverter.writeString(out, "text");
            FishAudioMsgPackConverter.writeString(out, vo.getText());
            FishAudioMsgPackConverter.writeString(out, "chunk_length");
            FishAudioMsgPackConverter.writeInt(out, vo.getChunk_length());
            FishAudioMsgPackConverter.writeString(out, "format");
            FishAudioMsgPackConverter.writeString(out, vo.getFormat());
            FishAudioMsgPackConverter.writeString(out, "mp3_bitrate");
            FishAudioMsgPackConverter.writeInt(out, vo.getMp3_bitrate());
            FishAudioMsgPackConverter.writeString(out, "references");
            List<FishAudioReferenceAudio> refs = vo.getReferences();
            if (refs == null) {
                FishAudioMsgPackConverter.writeArrayHeader(out, 0);
            } else {
                FishAudioMsgPackConverter.writeArrayHeader(out, refs.size());
                for (FishAudioReferenceAudio ref : refs) {
                    FishAudioMsgPackConverter.encodeFishAudioReferenceAudio(out, ref);
                }
            }
            FishAudioMsgPackConverter.writeString(out, "reference_id");
            if (vo.getReference_id() == null) {
                FishAudioMsgPackConverter.writeNil(out);
            } else {
                FishAudioMsgPackConverter.writeString(out, vo.getReference_id());
            }
            FishAudioMsgPackConverter.writeString(out, "normalize");
            FishAudioMsgPackConverter.writeBoolean(out, vo.getNormalize());
            FishAudioMsgPackConverter.writeString(out, "latency");
            FishAudioMsgPackConverter.writeString(out, vo.getLatency());
            out.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding FishAudioTTSRequestVo", e);
        }
    }

    private static void encodeFishAudioReferenceAudio(DataOutputStream out, FishAudioReferenceAudio ref) throws IOException {
        FishAudioMsgPackConverter.writeMapHeader(out, 2);
        FishAudioMsgPackConverter.writeString(out, "audio");
        byte[] audio = ref.getAudio();
        if (audio == null) {
            FishAudioMsgPackConverter.writeNil(out);
        } else {
            FishAudioMsgPackConverter.writeByteArray(out, audio);
        }
        FishAudioMsgPackConverter.writeString(out, "text");
        FishAudioMsgPackConverter.writeString(out, ref.getText());
    }

    private static void writeMapHeader(DataOutputStream out, int size) throws IOException {
        if (size < 16) {
            out.writeByte(0x80 | size);
        } else if (size < 65536) {
            out.writeByte(222);
            out.writeShort(size);
        } else {
            out.writeByte(223);
            out.writeInt(size);
        }
    }

    private static void writeArrayHeader(DataOutputStream out, int size) throws IOException {
        if (size < 16) {
            out.writeByte(0x90 | size);
        } else if (size < 65536) {
            out.writeByte(220);
            out.writeShort(size);
        } else {
            out.writeByte(221);
            out.writeInt(size);
        }
    }

    private static void writeNil(DataOutputStream out) throws IOException {
        out.writeByte(192);
    }

    private static void writeBoolean(DataOutputStream out, boolean value) throws IOException {
        out.writeByte(value ? 195 : 194);
    }

    private static void writeInt(DataOutputStream out, int value) throws IOException {
        if (value >= 0 && value < 128) {
            out.writeByte(value);
        } else if (value < 256) {
            out.writeByte(204);
            out.writeByte(value);
        } else if (value < 65536) {
            out.writeByte(205);
            out.writeShort(value);
        } else {
            out.writeByte(206);
            out.writeInt(value);
        }
    }

    private static void writeString(DataOutputStream out, String str) throws IOException {
        if (str == null) {
            FishAudioMsgPackConverter.writeNil(out);
            return;
        }
        byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
        int length = utf8.length;
        if (length < 32) {
            out.writeByte(0xA0 | length);
        } else if (length < 256) {
            out.writeByte(217);
            out.writeByte(length);
        } else if (length < 65536) {
            out.writeByte(218);
            out.writeShort(length);
        } else {
            out.writeByte(219);
            out.writeInt(length);
        }
        out.write(utf8);
    }

    private static void writeByteArray(DataOutputStream out, byte[] data) throws IOException {
        int length = data.length;
        if (length < 256) {
            out.writeByte(196);
            out.writeByte(length);
        } else if (length < 65536) {
            out.writeByte(197);
            out.writeShort(length);
        } else {
            out.writeByte(198);
            out.writeInt(length);
        }
        out.write(data);
    }
}

