/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.fishaudio.tts;

import com.litongjava.fishaudio.tts.FishAudioMsgPackConverter;
import com.litongjava.fishaudio.tts.FishAudioTTSRequestVo;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FishAudioClient {
    public static final String TTS_URL = "https://api.fish.audio/v1";

    public static ResponseVo speech(String text) {
        FishAudioTTSRequestVo req = new FishAudioTTSRequestVo().setText(text);
        return FishAudioClient.speech(req);
    }

    public static ResponseVo speech(FishAudioTTSRequestVo vo) {
        String apiKey = EnvUtils.get((String)"FISHAUDIO_API_KEY");
        return FishAudioClient.speech(apiKey, vo);
    }

    public static ResponseVo speech(String apiKey, FishAudioTTSRequestVo vo) {
        String apiPrefixUrl = EnvUtils.get((String)"FISHAUDIO_API_URL", (String)TTS_URL);
        return FishAudioClient.speech(apiPrefixUrl, apiKey, vo);
    }

    public static ResponseVo speech(String apiPrefixUrl, String apiKey, FishAudioTTSRequestVo vo) {
        byte[] payload = FishAudioMsgPackConverter.encodeFishAudioTTSRequestVo(vo);
        return FishAudioClient.speechRequest(apiPrefixUrl, apiKey, payload);
    }

    public static ResponseVo speechRequest(String apiPrefixUrl, String apiKey, byte[] payload) {
        String baseUrl = apiPrefixUrl + "/tts";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + apiKey);
        header.put("content-type", "application/msgpack");
        header.put("model", "speech-1.6");
        return FishAudioClient.execute(baseUrl, header, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResponseVo execute(String url, Map<String, String> header, byte[] payload) {
        MediaType mediaType = MediaType.parse((String)"application/msgpack");
        RequestBody body = RequestBody.create((byte[])payload, (MediaType)mediaType);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try (Response response = httpClient.newCall(request).execute();){
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((byte[])response.body().bytes());
                return responseVo;
            }
            String responseBody = response.body().string();
            ResponseVo responseVo = ResponseVo.fail((int)code, (String)responseBody);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

