/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.cache;

import com.jfinal.kit.StrKit;
import com.litongjava.cache.Cacheable;
import com.litongjava.jfinal.aop.AopInvocation;

public class CacheableModel {
    private String name;
    private String key;
    long ttl;

    public static CacheableModel buildCacheModel(AopInvocation inv, Object target) {
        long ttl;
        Cacheable cacheable = inv.getMethod().getAnnotation(Cacheable.class);
        String cacheName = null;
        String cacheKey = null;
        Class<?> targetClass = target.getClass();
        if (cacheable != null) {
            String name = cacheable.name();
            cacheName = StrKit.notBlank((String)name) ? name : ((cacheable = targetClass.getAnnotation(Cacheable.class)) != null ? cacheable.value() : targetClass.getSimpleName());
            String value = cacheable.value();
            if (StrKit.notBlank((String)name)) {
                cacheKey = value;
            } else {
                CacheableModel.buildCacheKey(inv);
            }
            ttl = cacheable.ttl();
        } else {
            cacheable = targetClass.getAnnotation(Cacheable.class);
            if (cacheable != null) {
                String name = cacheable.name();
                cacheName = StrKit.notBlank((String)name) ? name : targetClass.getSimpleName();
                ttl = cacheable.ttl();
            } else {
                cacheName = targetClass.getSimpleName();
                cacheKey = CacheableModel.buildCacheKey(inv);
                ttl = 3600L;
            }
        }
        return new CacheableModel(cacheName, cacheKey, ttl);
    }

    public static String buildCacheKey(AopInvocation inv) {
        Object[] args;
        StringBuilder sb = new StringBuilder(inv.getMethodName());
        for (Object object : args = inv.getArgs()) {
            sb.append("").append(object.hashCode());
        }
        return sb.toString();
    }

    public CacheableModel() {
    }

    public CacheableModel(String name, String key, long ttl) {
        this.name = name;
        this.key = key;
        this.ttl = ttl;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheableModel)) {
            return false;
        }
        CacheableModel other = (CacheableModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheableModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "CacheableModel(name=" + this.getName() + ", key=" + this.getKey() + ", ttl=" + this.getTtl() + ")";
    }
}

