/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.ehcache;

import com.litongjava.cache.Cacheable;
import com.litongjava.ehcache.EhCacheKit;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopInvocation;

public class EvictInterceptor
implements AopInterceptor {
    public void intercept(AopInvocation inv) {
        inv.invoke();
        String[] cacheNames = this.getCacheName(inv).split(",");
        if (cacheNames.length == 1) {
            EhCacheKit.removeAll(cacheNames[0].trim());
        } else {
            for (String cn : cacheNames) {
                EhCacheKit.removeAll(cn.trim());
            }
        }
    }

    protected String getCacheName(AopInvocation inv) {
        Cacheable cacheName = inv.getMethod().getAnnotation(Cacheable.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = inv.getTarget().getClass().getAnnotation(Cacheable.class);
        if (cacheName == null) {
            throw new RuntimeException("EvictInterceptor need CacheName annotation in controller.");
        }
        return cacheName.value();
    }
}

